/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.KubernetesClustersClient;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterList;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterPatchParameters;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterRestartNodeParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class KubernetesClustersClientImpl
implements KubernetesClustersClient {
    private final KubernetesClustersService service;
    private final NetworkCloudImpl client;

    KubernetesClustersClientImpl(NetworkCloudImpl client) {
        this.service = (KubernetesClustersService)RestProxy.create(KubernetesClustersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterList)res.getValue()).value(), ((KubernetesClusterList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterList)res.getValue()).value(), ((KubernetesClusterList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<KubernetesClusterInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<KubernetesClusterInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KubernetesClusterInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KubernetesClusterInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterList)res.getValue()).value(), ((KubernetesClusterList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterList)res.getValue()).value(), ((KubernetesClusterList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<KubernetesClusterInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<KubernetesClusterInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KubernetesClusterInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KubernetesClusterInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<KubernetesClusterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String kubernetesClusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<KubernetesClusterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String kubernetesClusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterInner> getByResourceGroupAsync(String resourceGroupName, String kubernetesClusterName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, kubernetesClusterName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((KubernetesClusterInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KubernetesClusterInner> getByResourceGroupWithResponse(String resourceGroupName, String kubernetesClusterName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, kubernetesClusterName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterInner getByResourceGroup(String resourceGroupName, String kubernetesClusterName) {
        return (KubernetesClusterInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, kubernetesClusterName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (kubernetesClusterParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterParameters is required and cannot be null."));
        }
        kubernetesClusterParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, kubernetesClusterParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (kubernetesClusterParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterParameters is required and cannot be null."));
        }
        kubernetesClusterParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, kubernetesClusterParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<KubernetesClusterInner>, KubernetesClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)KubernetesClusterInner.class), (Type)((Object)KubernetesClusterInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<KubernetesClusterInner>, KubernetesClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)KubernetesClusterInner.class), (Type)((Object)KubernetesClusterInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterInner>, KubernetesClusterInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterInner>, KubernetesClusterInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterInner> createOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterInner> createOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterInner createOrUpdate(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters) {
        return (KubernetesClusterInner)((Object)this.createOrUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterInner createOrUpdate(String resourceGroupName, String kubernetesClusterName, KubernetesClusterInner kubernetesClusterParameters, Context context) {
        return (KubernetesClusterInner)((Object)this.createOrUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String kubernetesClusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String kubernetesClusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String kubernetesClusterName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, kubernetesClusterName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String kubernetesClusterName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, kubernetesClusterName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String kubernetesClusterName) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String kubernetesClusterName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String kubernetesClusterName) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, kubernetesClusterName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String kubernetesClusterName, Context context) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, kubernetesClusterName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterPatchParameters kubernetesClusterUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (kubernetesClusterUpdateParameters != null) {
            kubernetesClusterUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterPatchParameters kubernetesClusterUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (kubernetesClusterUpdateParameters != null) {
            kubernetesClusterUpdateParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<KubernetesClusterInner>, KubernetesClusterInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterPatchParameters kubernetesClusterUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)KubernetesClusterInner.class), (Type)((Object)KubernetesClusterInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<KubernetesClusterInner>, KubernetesClusterInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName) {
        KubernetesClusterPatchParameters kubernetesClusterUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)KubernetesClusterInner.class), (Type)((Object)KubernetesClusterInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<KubernetesClusterInner>, KubernetesClusterInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterPatchParameters kubernetesClusterUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)KubernetesClusterInner.class), (Type)((Object)KubernetesClusterInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterInner>, KubernetesClusterInner> beginUpdate(String resourceGroupName, String kubernetesClusterName) {
        KubernetesClusterPatchParameters kubernetesClusterUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterInner>, KubernetesClusterInner> beginUpdate(String resourceGroupName, String kubernetesClusterName, KubernetesClusterPatchParameters kubernetesClusterUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterInner> updateAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterPatchParameters kubernetesClusterUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterInner> updateAsync(String resourceGroupName, String kubernetesClusterName) {
        KubernetesClusterPatchParameters kubernetesClusterUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterInner> updateAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterPatchParameters kubernetesClusterUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterInner update(String resourceGroupName, String kubernetesClusterName) {
        KubernetesClusterPatchParameters kubernetesClusterUpdateParameters = null;
        return (KubernetesClusterInner)((Object)this.updateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterInner update(String resourceGroupName, String kubernetesClusterName, KubernetesClusterPatchParameters kubernetesClusterUpdateParameters, Context context) {
        return (KubernetesClusterInner)((Object)this.updateAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartNodeWithResponseAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (kubernetesClusterRestartNodeParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterRestartNodeParameters is required and cannot be null."));
        }
        kubernetesClusterRestartNodeParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restartNode(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartNodeWithResponseAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (kubernetesClusterRestartNodeParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterRestartNodeParameters is required and cannot be null."));
        }
        kubernetesClusterRestartNodeParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restartNode(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestartNodeAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartNodeWithResponseAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestartNodeAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartNodeWithResponseAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestartNode(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters) {
        return this.beginRestartNodeAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestartNode(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters, Context context) {
        return this.beginRestartNodeAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> restartNodeAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters) {
        return this.beginRestartNodeAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> restartNodeAsync(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters, Context context) {
        return this.beginRestartNodeAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner restartNode(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters) {
        return (OperationStatusResultInner)this.restartNodeAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner restartNode(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters, Context context) {
        return (OperationStatusResultInner)this.restartNodeAsync(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterList)res.getValue()).value(), ((KubernetesClusterList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterList)res.getValue()).value(), ((KubernetesClusterList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterList)res.getValue()).value(), ((KubernetesClusterList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterList)res.getValue()).value(), ((KubernetesClusterList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudKubernet")
    public static interface KubernetesClustersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.NetworkCloud/kubernetesClusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KubernetesClusterList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KubernetesClusterList>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KubernetesClusterInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @BodyParam(value="application/json") KubernetesClusterInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @BodyParam(value="application/json") KubernetesClusterPatchParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/restartNode")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restartNode(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @BodyParam(value="application/json") KubernetesClusterRestartNodeParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KubernetesClusterList>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KubernetesClusterList>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

