/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.AadConfiguration;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfigurationPatch;
import com.azure.resourcemanager.networkcloud.models.AvailableUpgrade;
import com.azure.resourcemanager.networkcloud.models.ControlPlaneNodeConfiguration;
import com.azure.resourcemanager.networkcloud.models.ControlPlaneNodePatchConfiguration;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.FeatureStatus;
import com.azure.resourcemanager.networkcloud.models.InitialAgentPoolConfiguration;
import com.azure.resourcemanager.networkcloud.models.KubernetesCluster;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterNode;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterPatchParameters;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterProvisioningState;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterRestartNodeParameters;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.NetworkConfiguration;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class KubernetesClusterImpl
implements KubernetesCluster,
KubernetesCluster.Definition,
KubernetesCluster.Update {
    private KubernetesClusterInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String kubernetesClusterName;
    private KubernetesClusterPatchParameters updateKubernetesClusterUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AadConfiguration aadConfiguration() {
        return this.innerModel().aadConfiguration();
    }

    @Override
    public AdministratorConfiguration administratorConfiguration() {
        return this.innerModel().administratorConfiguration();
    }

    @Override
    public List<String> attachedNetworkIds() {
        List<String> inner = this.innerModel().attachedNetworkIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<AvailableUpgrade> availableUpgrades() {
        List<AvailableUpgrade> inner = this.innerModel().availableUpgrades();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public String connectedClusterId() {
        return this.innerModel().connectedClusterId();
    }

    @Override
    public String controlPlaneKubernetesVersion() {
        return this.innerModel().controlPlaneKubernetesVersion();
    }

    @Override
    public ControlPlaneNodeConfiguration controlPlaneNodeConfiguration() {
        return this.innerModel().controlPlaneNodeConfiguration();
    }

    @Override
    public KubernetesClusterDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public List<FeatureStatus> featureStatuses() {
        List<FeatureStatus> inner = this.innerModel().featureStatuses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<InitialAgentPoolConfiguration> initialAgentPoolConfigurations() {
        List<InitialAgentPoolConfiguration> inner = this.innerModel().initialAgentPoolConfigurations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String kubernetesVersion() {
        return this.innerModel().kubernetesVersion();
    }

    @Override
    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration() {
        return this.innerModel().managedResourceGroupConfiguration();
    }

    @Override
    public NetworkConfiguration networkConfiguration() {
        return this.innerModel().networkConfiguration();
    }

    @Override
    public List<KubernetesClusterNode> nodes() {
        List<KubernetesClusterNode> inner = this.innerModel().nodes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public KubernetesClusterProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public KubernetesClusterInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public KubernetesClusterImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public KubernetesCluster create() {
        this.innerObject = this.serviceManager.serviceClient().getKubernetesClusters().createOrUpdate(this.resourceGroupName, this.kubernetesClusterName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public KubernetesCluster create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getKubernetesClusters().createOrUpdate(this.resourceGroupName, this.kubernetesClusterName, this.innerModel(), context);
        return this;
    }

    KubernetesClusterImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new KubernetesClusterInner();
        this.serviceManager = serviceManager;
        this.kubernetesClusterName = name;
    }

    @Override
    public KubernetesClusterImpl update() {
        this.updateKubernetesClusterUpdateParameters = new KubernetesClusterPatchParameters();
        return this;
    }

    @Override
    public KubernetesCluster apply() {
        this.innerObject = this.serviceManager.serviceClient().getKubernetesClusters().update(this.resourceGroupName, this.kubernetesClusterName, this.updateKubernetesClusterUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public KubernetesCluster apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getKubernetesClusters().update(this.resourceGroupName, this.kubernetesClusterName, this.updateKubernetesClusterUpdateParameters, context);
        return this;
    }

    KubernetesClusterImpl(KubernetesClusterInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "kubernetesClusters");
    }

    @Override
    public KubernetesCluster refresh() {
        this.innerObject = (KubernetesClusterInner)((Object)this.serviceManager.serviceClient().getKubernetesClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.kubernetesClusterName, Context.NONE).getValue());
        return this;
    }

    @Override
    public KubernetesCluster refresh(Context context) {
        this.innerObject = (KubernetesClusterInner)((Object)this.serviceManager.serviceClient().getKubernetesClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.kubernetesClusterName, context).getValue());
        return this;
    }

    @Override
    public OperationStatusResult restartNode(KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters) {
        return this.serviceManager.kubernetesClusters().restartNode(this.resourceGroupName, this.kubernetesClusterName, kubernetesClusterRestartNodeParameters);
    }

    @Override
    public OperationStatusResult restartNode(KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters, Context context) {
        return this.serviceManager.kubernetesClusters().restartNode(this.resourceGroupName, this.kubernetesClusterName, kubernetesClusterRestartNodeParameters, context);
    }

    @Override
    public KubernetesClusterImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public KubernetesClusterImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public KubernetesClusterImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public KubernetesClusterImpl withControlPlaneNodeConfiguration(ControlPlaneNodeConfiguration controlPlaneNodeConfiguration) {
        this.innerModel().withControlPlaneNodeConfiguration(controlPlaneNodeConfiguration);
        return this;
    }

    @Override
    public KubernetesClusterImpl withInitialAgentPoolConfigurations(List<InitialAgentPoolConfiguration> initialAgentPoolConfigurations) {
        this.innerModel().withInitialAgentPoolConfigurations(initialAgentPoolConfigurations);
        return this;
    }

    @Override
    public KubernetesClusterImpl withKubernetesVersion(String kubernetesVersion) {
        if (this.isInCreateMode()) {
            this.innerModel().withKubernetesVersion(kubernetesVersion);
            return this;
        }
        this.updateKubernetesClusterUpdateParameters.withKubernetesVersion(kubernetesVersion);
        return this;
    }

    @Override
    public KubernetesClusterImpl withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.innerModel().withNetworkConfiguration(networkConfiguration);
        return this;
    }

    @Override
    public KubernetesClusterImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateKubernetesClusterUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public KubernetesClusterImpl withAadConfiguration(AadConfiguration aadConfiguration) {
        this.innerModel().withAadConfiguration(aadConfiguration);
        return this;
    }

    @Override
    public KubernetesClusterImpl withAdministratorConfiguration(AdministratorConfiguration administratorConfiguration) {
        this.innerModel().withAdministratorConfiguration(administratorConfiguration);
        return this;
    }

    @Override
    public KubernetesClusterImpl withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration managedResourceGroupConfiguration) {
        this.innerModel().withManagedResourceGroupConfiguration(managedResourceGroupConfiguration);
        return this;
    }

    @Override
    public KubernetesClusterImpl withAdministratorConfiguration(AdministratorConfigurationPatch administratorConfiguration) {
        this.updateKubernetesClusterUpdateParameters.withAdministratorConfiguration(administratorConfiguration);
        return this;
    }

    @Override
    public KubernetesClusterImpl withControlPlaneNodeConfiguration(ControlPlaneNodePatchConfiguration controlPlaneNodeConfiguration) {
        this.updateKubernetesClusterUpdateParameters.withControlPlaneNodeConfiguration(controlPlaneNodeConfiguration);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

