/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.ClustersClient;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.ClusterContinueUpdateVersionParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterDeployParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterList;
import com.azure.resourcemanager.networkcloud.models.ClusterPatchParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterScanRuntimeParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateVersionParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ClustersClientImpl
implements ClustersClient {
    private final ClustersService service;
    private final NetworkCloudImpl client;

    ClustersClientImpl(NetworkCloudImpl client) {
        this.service = (ClustersService)RestProxy.create(ClustersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterList)res.getValue()).value(), ((ClusterList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterList)res.getValue()).value(), ((ClusterList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ClusterInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ClusterInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterList)res.getValue()).value(), ((ClusterList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterList)res.getValue()).value(), ((ClusterList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ClusterInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ClusterInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ClusterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String clusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ClusterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String clusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterInner> getByResourceGroupAsync(String resourceGroupName, String clusterName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, clusterName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ClusterInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ClusterInner> getByResourceGroupWithResponse(String resourceGroupName, String clusterName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, clusterName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterInner getByResourceGroup(String resourceGroupName, String clusterName) {
        return (ClusterInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, clusterName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String clusterName, ClusterInner clusterParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterParameters is required and cannot be null."));
        }
        clusterParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String clusterName, ClusterInner clusterParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterParameters is required and cannot be null."));
        }
        clusterParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClusterInner>, ClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, ClusterInner clusterParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, clusterParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ClusterInner.class), (Type)((Object)ClusterInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClusterInner>, ClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, ClusterInner clusterParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, clusterParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ClusterInner.class), (Type)((Object)ClusterInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterInner>, ClusterInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, ClusterInner clusterParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, clusterParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterInner>, ClusterInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, ClusterInner clusterParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, clusterParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterInner> createOrUpdateAsync(String resourceGroupName, String clusterName, ClusterInner clusterParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, clusterParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterInner> createOrUpdateAsync(String resourceGroupName, String clusterName, ClusterInner clusterParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, clusterParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterInner createOrUpdate(String resourceGroupName, String clusterName, ClusterInner clusterParameters) {
        return (ClusterInner)((Object)this.createOrUpdateAsync(resourceGroupName, clusterName, clusterParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterInner createOrUpdate(String resourceGroupName, String clusterName, ClusterInner clusterParameters, Context context) {
        return (ClusterInner)((Object)this.createOrUpdateAsync(resourceGroupName, clusterName, clusterParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String clusterName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String clusterName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String clusterName) {
        return this.beginDeleteAsync(resourceGroupName, clusterName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String clusterName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String clusterName) {
        return this.beginDeleteAsync(resourceGroupName, clusterName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String clusterName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String clusterName) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, clusterName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String clusterName, Context context) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, clusterName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName, ClusterPatchParameters clusterUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterUpdateParameters != null) {
            clusterUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName, ClusterPatchParameters clusterUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterUpdateParameters != null) {
            clusterUpdateParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClusterInner>, ClusterInner> beginUpdateAsync(String resourceGroupName, String clusterName, ClusterPatchParameters clusterUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, clusterUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ClusterInner.class), (Type)((Object)ClusterInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClusterInner>, ClusterInner> beginUpdateAsync(String resourceGroupName, String clusterName) {
        ClusterPatchParameters clusterUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, clusterUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ClusterInner.class), (Type)((Object)ClusterInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClusterInner>, ClusterInner> beginUpdateAsync(String resourceGroupName, String clusterName, ClusterPatchParameters clusterUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, clusterUpdateParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ClusterInner.class), (Type)((Object)ClusterInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterInner>, ClusterInner> beginUpdate(String resourceGroupName, String clusterName) {
        ClusterPatchParameters clusterUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, clusterName, clusterUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterInner>, ClusterInner> beginUpdate(String resourceGroupName, String clusterName, ClusterPatchParameters clusterUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, clusterUpdateParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterInner> updateAsync(String resourceGroupName, String clusterName, ClusterPatchParameters clusterUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, clusterUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterInner> updateAsync(String resourceGroupName, String clusterName) {
        ClusterPatchParameters clusterUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, clusterName, clusterUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterInner> updateAsync(String resourceGroupName, String clusterName, ClusterPatchParameters clusterUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, clusterUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterInner update(String resourceGroupName, String clusterName) {
        ClusterPatchParameters clusterUpdateParameters = null;
        return (ClusterInner)((Object)this.updateAsync(resourceGroupName, clusterName, clusterUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterInner update(String resourceGroupName, String clusterName, ClusterPatchParameters clusterUpdateParameters, Context context) {
        return (ClusterInner)((Object)this.updateAsync(resourceGroupName, clusterName, clusterUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> continueUpdateVersionWithResponseAsync(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterContinueUpdateVersionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterContinueUpdateVersionParameters is required and cannot be null."));
        }
        clusterContinueUpdateVersionParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.continueUpdateVersion(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterContinueUpdateVersionParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> continueUpdateVersionWithResponseAsync(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterContinueUpdateVersionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterContinueUpdateVersionParameters is required and cannot be null."));
        }
        clusterContinueUpdateVersionParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.continueUpdateVersion(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterContinueUpdateVersionParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginContinueUpdateVersionAsync(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.continueUpdateVersionWithResponseAsync(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginContinueUpdateVersionAsync(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.continueUpdateVersionWithResponseAsync(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginContinueUpdateVersion(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters) {
        return this.beginContinueUpdateVersionAsync(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginContinueUpdateVersion(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters, Context context) {
        return this.beginContinueUpdateVersionAsync(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> continueUpdateVersionAsync(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters) {
        return this.beginContinueUpdateVersionAsync(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> continueUpdateVersionAsync(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters, Context context) {
        return this.beginContinueUpdateVersionAsync(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner continueUpdateVersion(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters) {
        return (OperationStatusResultInner)this.continueUpdateVersionAsync(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner continueUpdateVersion(String resourceGroupName, String clusterName, ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters, Context context) {
        return (OperationStatusResultInner)this.continueUpdateVersionAsync(resourceGroupName, clusterName, clusterContinueUpdateVersionParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deployWithResponseAsync(String resourceGroupName, String clusterName, ClusterDeployParameters clusterDeployParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterDeployParameters != null) {
            clusterDeployParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deploy(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterDeployParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deployWithResponseAsync(String resourceGroupName, String clusterName, ClusterDeployParameters clusterDeployParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterDeployParameters != null) {
            clusterDeployParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deploy(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterDeployParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeployAsync(String resourceGroupName, String clusterName, ClusterDeployParameters clusterDeployParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deployWithResponseAsync(resourceGroupName, clusterName, clusterDeployParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeployAsync(String resourceGroupName, String clusterName) {
        ClusterDeployParameters clusterDeployParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deployWithResponseAsync(resourceGroupName, clusterName, clusterDeployParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeployAsync(String resourceGroupName, String clusterName, ClusterDeployParameters clusterDeployParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deployWithResponseAsync(resourceGroupName, clusterName, clusterDeployParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeploy(String resourceGroupName, String clusterName) {
        ClusterDeployParameters clusterDeployParameters = null;
        return this.beginDeployAsync(resourceGroupName, clusterName, clusterDeployParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeploy(String resourceGroupName, String clusterName, ClusterDeployParameters clusterDeployParameters, Context context) {
        return this.beginDeployAsync(resourceGroupName, clusterName, clusterDeployParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deployAsync(String resourceGroupName, String clusterName, ClusterDeployParameters clusterDeployParameters) {
        return this.beginDeployAsync(resourceGroupName, clusterName, clusterDeployParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deployAsync(String resourceGroupName, String clusterName) {
        ClusterDeployParameters clusterDeployParameters = null;
        return this.beginDeployAsync(resourceGroupName, clusterName, clusterDeployParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deployAsync(String resourceGroupName, String clusterName, ClusterDeployParameters clusterDeployParameters, Context context) {
        return this.beginDeployAsync(resourceGroupName, clusterName, clusterDeployParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner deploy(String resourceGroupName, String clusterName) {
        ClusterDeployParameters clusterDeployParameters = null;
        return (OperationStatusResultInner)this.deployAsync(resourceGroupName, clusterName, clusterDeployParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner deploy(String resourceGroupName, String clusterName, ClusterDeployParameters clusterDeployParameters, Context context) {
        return (OperationStatusResultInner)this.deployAsync(resourceGroupName, clusterName, clusterDeployParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> scanRuntimeWithResponseAsync(String resourceGroupName, String clusterName, ClusterScanRuntimeParameters clusterScanRuntimeParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterScanRuntimeParameters != null) {
            clusterScanRuntimeParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.scanRuntime(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterScanRuntimeParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> scanRuntimeWithResponseAsync(String resourceGroupName, String clusterName, ClusterScanRuntimeParameters clusterScanRuntimeParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterScanRuntimeParameters != null) {
            clusterScanRuntimeParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.scanRuntime(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterScanRuntimeParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginScanRuntimeAsync(String resourceGroupName, String clusterName, ClusterScanRuntimeParameters clusterScanRuntimeParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.scanRuntimeWithResponseAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginScanRuntimeAsync(String resourceGroupName, String clusterName) {
        ClusterScanRuntimeParameters clusterScanRuntimeParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.scanRuntimeWithResponseAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginScanRuntimeAsync(String resourceGroupName, String clusterName, ClusterScanRuntimeParameters clusterScanRuntimeParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.scanRuntimeWithResponseAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginScanRuntime(String resourceGroupName, String clusterName) {
        ClusterScanRuntimeParameters clusterScanRuntimeParameters = null;
        return this.beginScanRuntimeAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginScanRuntime(String resourceGroupName, String clusterName, ClusterScanRuntimeParameters clusterScanRuntimeParameters, Context context) {
        return this.beginScanRuntimeAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> scanRuntimeAsync(String resourceGroupName, String clusterName, ClusterScanRuntimeParameters clusterScanRuntimeParameters) {
        return this.beginScanRuntimeAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> scanRuntimeAsync(String resourceGroupName, String clusterName) {
        ClusterScanRuntimeParameters clusterScanRuntimeParameters = null;
        return this.beginScanRuntimeAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> scanRuntimeAsync(String resourceGroupName, String clusterName, ClusterScanRuntimeParameters clusterScanRuntimeParameters, Context context) {
        return this.beginScanRuntimeAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner scanRuntime(String resourceGroupName, String clusterName) {
        ClusterScanRuntimeParameters clusterScanRuntimeParameters = null;
        return (OperationStatusResultInner)this.scanRuntimeAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner scanRuntime(String resourceGroupName, String clusterName, ClusterScanRuntimeParameters clusterScanRuntimeParameters, Context context) {
        return (OperationStatusResultInner)this.scanRuntimeAsync(resourceGroupName, clusterName, clusterScanRuntimeParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateVersionWithResponseAsync(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterUpdateVersionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterUpdateVersionParameters is required and cannot be null."));
        }
        clusterUpdateVersionParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateVersion(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterUpdateVersionParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateVersionWithResponseAsync(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (clusterUpdateVersionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterUpdateVersionParameters is required and cannot be null."));
        }
        clusterUpdateVersionParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateVersion(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, clusterUpdateVersionParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUpdateVersionAsync(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateVersionWithResponseAsync(resourceGroupName, clusterName, clusterUpdateVersionParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUpdateVersionAsync(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateVersionWithResponseAsync(resourceGroupName, clusterName, clusterUpdateVersionParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUpdateVersion(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters) {
        return this.beginUpdateVersionAsync(resourceGroupName, clusterName, clusterUpdateVersionParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUpdateVersion(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters, Context context) {
        return this.beginUpdateVersionAsync(resourceGroupName, clusterName, clusterUpdateVersionParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> updateVersionAsync(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters) {
        return this.beginUpdateVersionAsync(resourceGroupName, clusterName, clusterUpdateVersionParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> updateVersionAsync(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters, Context context) {
        return this.beginUpdateVersionAsync(resourceGroupName, clusterName, clusterUpdateVersionParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner updateVersion(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters) {
        return (OperationStatusResultInner)this.updateVersionAsync(resourceGroupName, clusterName, clusterUpdateVersionParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner updateVersion(String resourceGroupName, String clusterName, ClusterUpdateVersionParameters clusterUpdateVersionParameters, Context context) {
        return (OperationStatusResultInner)this.updateVersionAsync(resourceGroupName, clusterName, clusterUpdateVersionParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterList)res.getValue()).value(), ((ClusterList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterList)res.getValue()).value(), ((ClusterList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterList)res.getValue()).value(), ((ClusterList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterList)res.getValue()).value(), ((ClusterList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudClusters")
    public static interface ClustersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.NetworkCloud/clusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ClusterList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ClusterList>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ClusterInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @BodyParam(value="application/json") ClusterInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @BodyParam(value="application/json") ClusterPatchParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/continueUpdateVersion")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> continueUpdateVersion(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @BodyParam(value="application/json") ClusterContinueUpdateVersionParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/deploy")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deploy(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @BodyParam(value="application/json") ClusterDeployParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/scanRuntime")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> scanRuntime(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @BodyParam(value="application/json") ClusterScanRuntimeParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/updateVersion")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updateVersion(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @BodyParam(value="application/json") ClusterUpdateVersionParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ClusterList>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ClusterList>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

