/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterMetricsConfigurationInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfiguration;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationPatchParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ClusterMetricsConfigurationImpl
implements ClusterMetricsConfiguration,
ClusterMetricsConfiguration.Definition,
ClusterMetricsConfiguration.Update {
    private ClusterMetricsConfigurationInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String metricsConfigurationName;
    private ClusterMetricsConfigurationPatchParameters updateMetricsConfigurationUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public long collectionInterval() {
        return this.innerModel().collectionInterval();
    }

    @Override
    public ClusterMetricsConfigurationDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public List<String> disabledMetrics() {
        List<String> inner = this.innerModel().disabledMetrics();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> enabledMetrics() {
        List<String> inner = this.innerModel().enabledMetrics();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ClusterMetricsConfigurationProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ClusterMetricsConfigurationInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterMetricsConfigurationImpl withExistingCluster(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public ClusterMetricsConfiguration create() {
        this.innerObject = this.serviceManager.serviceClient().getMetricsConfigurations().createOrUpdate(this.resourceGroupName, this.clusterName, this.metricsConfigurationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ClusterMetricsConfiguration create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMetricsConfigurations().createOrUpdate(this.resourceGroupName, this.clusterName, this.metricsConfigurationName, this.innerModel(), context);
        return this;
    }

    ClusterMetricsConfigurationImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new ClusterMetricsConfigurationInner();
        this.serviceManager = serviceManager;
        this.metricsConfigurationName = name;
    }

    @Override
    public ClusterMetricsConfigurationImpl update() {
        this.updateMetricsConfigurationUpdateParameters = new ClusterMetricsConfigurationPatchParameters();
        return this;
    }

    @Override
    public ClusterMetricsConfiguration apply() {
        this.innerObject = this.serviceManager.serviceClient().getMetricsConfigurations().update(this.resourceGroupName, this.clusterName, this.metricsConfigurationName, this.updateMetricsConfigurationUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public ClusterMetricsConfiguration apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMetricsConfigurations().update(this.resourceGroupName, this.clusterName, this.metricsConfigurationName, this.updateMetricsConfigurationUpdateParameters, context);
        return this;
    }

    ClusterMetricsConfigurationImpl(ClusterMetricsConfigurationInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "clusters");
        this.metricsConfigurationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "metricsConfigurations");
    }

    @Override
    public ClusterMetricsConfiguration refresh() {
        this.innerObject = (ClusterMetricsConfigurationInner)((Object)this.serviceManager.serviceClient().getMetricsConfigurations().getWithResponse(this.resourceGroupName, this.clusterName, this.metricsConfigurationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ClusterMetricsConfiguration refresh(Context context) {
        this.innerObject = (ClusterMetricsConfigurationInner)((Object)this.serviceManager.serviceClient().getMetricsConfigurations().getWithResponse(this.resourceGroupName, this.clusterName, this.metricsConfigurationName, context).getValue());
        return this;
    }

    @Override
    public ClusterMetricsConfigurationImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ClusterMetricsConfigurationImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ClusterMetricsConfigurationImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public ClusterMetricsConfigurationImpl withCollectionInterval(long collectionInterval) {
        this.innerModel().withCollectionInterval(collectionInterval);
        return this;
    }

    @Override
    public ClusterMetricsConfigurationImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateMetricsConfigurationUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public ClusterMetricsConfigurationImpl withEnabledMetrics(List<String> enabledMetrics) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnabledMetrics(enabledMetrics);
            return this;
        }
        this.updateMetricsConfigurationUpdateParameters.withEnabledMetrics(enabledMetrics);
        return this;
    }

    @Override
    public ClusterMetricsConfigurationImpl withCollectionInterval(Long collectionInterval) {
        this.updateMetricsConfigurationUpdateParameters.withCollectionInterval(collectionInterval);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

