/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterManagerInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ClusterAvailableVersion;
import com.azure.resourcemanager.networkcloud.models.ClusterManager;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerPatchParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ClusterManagerImpl
implements ClusterManager,
ClusterManager.Definition,
ClusterManager.Update {
    private ClusterManagerInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String clusterManagerName;
    private ClusterManagerPatchParameters updateClusterManagerUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String analyticsWorkspaceId() {
        return this.innerModel().analyticsWorkspaceId();
    }

    @Override
    public List<String> availabilityZones() {
        List<String> inner = this.innerModel().availabilityZones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ClusterAvailableVersion> clusterVersions() {
        List<ClusterAvailableVersion> inner = this.innerModel().clusterVersions();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ClusterManagerDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public String fabricControllerId() {
        return this.innerModel().fabricControllerId();
    }

    @Override
    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration() {
        return this.innerModel().managedResourceGroupConfiguration();
    }

    @Override
    public ExtendedLocation managerExtendedLocation() {
        return this.innerModel().managerExtendedLocation();
    }

    @Override
    public ClusterManagerProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String vmSize() {
        return this.innerModel().vmSize();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ClusterManagerInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterManagerImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ClusterManager create() {
        this.innerObject = this.serviceManager.serviceClient().getClusterManagers().createOrUpdate(this.resourceGroupName, this.clusterManagerName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ClusterManager create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClusterManagers().createOrUpdate(this.resourceGroupName, this.clusterManagerName, this.innerModel(), context);
        return this;
    }

    ClusterManagerImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new ClusterManagerInner();
        this.serviceManager = serviceManager;
        this.clusterManagerName = name;
    }

    @Override
    public ClusterManagerImpl update() {
        this.updateClusterManagerUpdateParameters = new ClusterManagerPatchParameters();
        return this;
    }

    @Override
    public ClusterManager apply() {
        this.innerObject = (ClusterManagerInner)((Object)this.serviceManager.serviceClient().getClusterManagers().updateWithResponse(this.resourceGroupName, this.clusterManagerName, this.updateClusterManagerUpdateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public ClusterManager apply(Context context) {
        this.innerObject = (ClusterManagerInner)((Object)this.serviceManager.serviceClient().getClusterManagers().updateWithResponse(this.resourceGroupName, this.clusterManagerName, this.updateClusterManagerUpdateParameters, context).getValue());
        return this;
    }

    ClusterManagerImpl(ClusterManagerInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterManagerName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "clusterManagers");
    }

    @Override
    public ClusterManager refresh() {
        this.innerObject = (ClusterManagerInner)((Object)this.serviceManager.serviceClient().getClusterManagers().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterManagerName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ClusterManager refresh(Context context) {
        this.innerObject = (ClusterManagerInner)((Object)this.serviceManager.serviceClient().getClusterManagers().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterManagerName, context).getValue());
        return this;
    }

    @Override
    public ClusterManagerImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ClusterManagerImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ClusterManagerImpl withFabricControllerId(String fabricControllerId) {
        this.innerModel().withFabricControllerId(fabricControllerId);
        return this;
    }

    @Override
    public ClusterManagerImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateClusterManagerUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public ClusterManagerImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateClusterManagerUpdateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ClusterManagerImpl withAnalyticsWorkspaceId(String analyticsWorkspaceId) {
        this.innerModel().withAnalyticsWorkspaceId(analyticsWorkspaceId);
        return this;
    }

    @Override
    public ClusterManagerImpl withAvailabilityZones(List<String> availabilityZones) {
        this.innerModel().withAvailabilityZones(availabilityZones);
        return this;
    }

    @Override
    public ClusterManagerImpl withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration managedResourceGroupConfiguration) {
        this.innerModel().withManagedResourceGroupConfiguration(managedResourceGroupConfiguration);
        return this;
    }

    @Override
    public ClusterManagerImpl withVmSize(String vmSize) {
        this.innerModel().withVmSize(vmSize);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

