/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.BareMetalMachinesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCordonParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineList;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePatchParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePowerOffParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineReplaceParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunCommandParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunDataExtractsParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunReadCommandsParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BareMetalMachinesClientImpl
implements BareMetalMachinesClient {
    private final BareMetalMachinesService service;
    private final NetworkCloudImpl client;

    BareMetalMachinesClientImpl(NetworkCloudImpl client) {
        this.service = (BareMetalMachinesService)RestProxy.create(BareMetalMachinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BareMetalMachineInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BareMetalMachineInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BareMetalMachineInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BareMetalMachineInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BareMetalMachineInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BareMetalMachineInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> getByResourceGroupAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, bareMetalMachineName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BareMetalMachineInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BareMetalMachineInner> getByResourceGroupWithResponse(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, bareMetalMachineName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner getByResourceGroup(String resourceGroupName, String bareMetalMachineName) {
        return (BareMetalMachineInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, bareMetalMachineName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineParameters is required and cannot be null."));
        }
        bareMetalMachineParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineParameters is required and cannot be null."));
        }
        bareMetalMachineParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginCreateOrUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginCreateOrUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginCreateOrUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginCreateOrUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> createOrUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> createOrUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner createOrUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters) {
        return (BareMetalMachineInner)((Object)this.createOrUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner createOrUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, Context context) {
        return (BareMetalMachineInner)((Object)this.createOrUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String bareMetalMachineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, bareMetalMachineName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String bareMetalMachineName) {
        return this.beginDeleteAsync(resourceGroupName, bareMetalMachineName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, bareMetalMachineName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.beginDeleteAsync(resourceGroupName, bareMetalMachineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, bareMetalMachineName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String bareMetalMachineName) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, bareMetalMachineName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, bareMetalMachineName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineUpdateParameters != null) {
            bareMetalMachineUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineUpdateParameters != null) {
            bareMetalMachineUpdateParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdateAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePatchParameters bareMetalMachineUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdate(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePatchParameters bareMetalMachineUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> updateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> updateAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePatchParameters bareMetalMachineUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> updateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner update(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePatchParameters bareMetalMachineUpdateParameters = null;
        return (BareMetalMachineInner)((Object)this.updateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner update(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters, Context context) {
        return (BareMetalMachineInner)((Object)this.updateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> cordonWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineCordonParameters != null) {
            bareMetalMachineCordonParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cordon(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> cordonWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineCordonParameters != null) {
            bareMetalMachineCordonParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cordon(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordonAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.cordonWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordonAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineCordonParameters bareMetalMachineCordonParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.cordonWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordonAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.cordonWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordon(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineCordonParameters bareMetalMachineCordonParameters = null;
        return this.beginCordonAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordon(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        return this.beginCordonAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> cordonAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters) {
        return this.beginCordonAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> cordonAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineCordonParameters bareMetalMachineCordonParameters = null;
        return this.beginCordonAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> cordonAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        return this.beginCordonAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner cordon(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineCordonParameters bareMetalMachineCordonParameters = null;
        return (OperationStatusResultInner)this.cordonAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner cordon(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        return (OperationStatusResultInner)this.cordonAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachinePowerOffParameters != null) {
            bareMetalMachinePowerOffParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.powerOff(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachinePowerOffParameters != null) {
            bareMetalMachinePowerOffParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.powerOff(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOffAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOffAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOffAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOff(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters = null;
        return this.beginPowerOffAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOff(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> powerOffAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters) {
        return this.beginPowerOffAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> powerOffAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters = null;
        return this.beginPowerOffAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> powerOffAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner powerOff(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters = null;
        return (OperationStatusResultInner)this.powerOffAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner powerOff(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        return (OperationStatusResultInner)this.powerOffAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reimage(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.reimage(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReimageAsync(String resourceGroupName, String bareMetalMachineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReimageAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, bareMetalMachineName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReimage(String resourceGroupName, String bareMetalMachineName) {
        return this.beginReimageAsync(resourceGroupName, bareMetalMachineName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReimage(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginReimageAsync(resourceGroupName, bareMetalMachineName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> reimageAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.beginReimageAsync(resourceGroupName, bareMetalMachineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> reimageAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginReimageAsync(resourceGroupName, bareMetalMachineName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner reimage(String resourceGroupName, String bareMetalMachineName) {
        return (OperationStatusResultInner)this.reimageAsync(resourceGroupName, bareMetalMachineName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner reimage(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (OperationStatusResultInner)this.reimageAsync(resourceGroupName, bareMetalMachineName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> replaceWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineReplaceParameters != null) {
            bareMetalMachineReplaceParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.replace(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> replaceWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineReplaceParameters != null) {
            bareMetalMachineReplaceParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.replace(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplaceAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.replaceWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplaceAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.replaceWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplaceAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.replaceWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplace(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters = null;
        return this.beginReplaceAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplace(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        return this.beginReplaceAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> replaceAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters) {
        return this.beginReplaceAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> replaceAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters = null;
        return this.beginReplaceAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> replaceAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        return this.beginReplaceAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner replace(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters = null;
        return (OperationStatusResultInner)this.replaceAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner replace(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        return (OperationStatusResultInner)this.replaceAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restart(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestartAsync(String resourceGroupName, String bareMetalMachineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestartAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, bareMetalMachineName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestart(String resourceGroupName, String bareMetalMachineName) {
        return this.beginRestartAsync(resourceGroupName, bareMetalMachineName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestart(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginRestartAsync(resourceGroupName, bareMetalMachineName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> restartAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.beginRestartAsync(resourceGroupName, bareMetalMachineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> restartAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginRestartAsync(resourceGroupName, bareMetalMachineName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner restart(String resourceGroupName, String bareMetalMachineName) {
        return (OperationStatusResultInner)this.restartAsync(resourceGroupName, bareMetalMachineName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner restart(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (OperationStatusResultInner)this.restartAsync(resourceGroupName, bareMetalMachineName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runCommandWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunCommandParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineRunCommandParameters is required and cannot be null."));
        }
        bareMetalMachineRunCommandParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.runCommand(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runCommandWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunCommandParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineRunCommandParameters is required and cannot be null."));
        }
        bareMetalMachineRunCommandParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.runCommand(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunCommandAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.runCommandWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunCommandAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.runCommandWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        return this.beginRunCommandAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        return this.beginRunCommandAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> runCommandAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        return this.beginRunCommandAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> runCommandAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        return this.beginRunCommandAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        return (OperationStatusResultInner)this.runCommandAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        return (OperationStatusResultInner)this.runCommandAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runDataExtractsWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunDataExtractsParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineRunDataExtractsParameters is required and cannot be null."));
        }
        bareMetalMachineRunDataExtractsParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.runDataExtracts(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runDataExtractsWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunDataExtractsParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineRunDataExtractsParameters is required and cannot be null."));
        }
        bareMetalMachineRunDataExtractsParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.runDataExtracts(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunDataExtractsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.runDataExtractsWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunDataExtractsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.runDataExtractsWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        return this.beginRunDataExtractsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        return this.beginRunDataExtractsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> runDataExtractsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        return this.beginRunDataExtractsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> runDataExtractsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        return this.beginRunDataExtractsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        return (OperationStatusResultInner)this.runDataExtractsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        return (OperationStatusResultInner)this.runDataExtractsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runReadCommandsWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunReadCommandsParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineRunReadCommandsParameters is required and cannot be null."));
        }
        bareMetalMachineRunReadCommandsParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.runReadCommands(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runReadCommandsWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunReadCommandsParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineRunReadCommandsParameters is required and cannot be null."));
        }
        bareMetalMachineRunReadCommandsParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.runReadCommands(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunReadCommandsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.runReadCommandsWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunReadCommandsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.runReadCommandsWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        return this.beginRunReadCommandsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        return this.beginRunReadCommandsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> runReadCommandsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        return this.beginRunReadCommandsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> runReadCommandsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        return this.beginRunReadCommandsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        return (OperationStatusResultInner)this.runReadCommandsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        return (OperationStatusResultInner)this.runReadCommandsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStartAsync(String resourceGroupName, String bareMetalMachineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStartAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, bareMetalMachineName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStart(String resourceGroupName, String bareMetalMachineName) {
        return this.beginStartAsync(resourceGroupName, bareMetalMachineName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStart(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginStartAsync(resourceGroupName, bareMetalMachineName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> startAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.beginStartAsync(resourceGroupName, bareMetalMachineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> startAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginStartAsync(resourceGroupName, bareMetalMachineName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner start(String resourceGroupName, String bareMetalMachineName) {
        return (OperationStatusResultInner)this.startAsync(resourceGroupName, bareMetalMachineName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner start(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (OperationStatusResultInner)this.startAsync(resourceGroupName, bareMetalMachineName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> uncordonWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.uncordon(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> uncordonWithResponseAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.uncordon(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUncordonAsync(String resourceGroupName, String bareMetalMachineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.uncordonWithResponseAsync(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUncordonAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.uncordonWithResponseAsync(resourceGroupName, bareMetalMachineName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUncordon(String resourceGroupName, String bareMetalMachineName) {
        return this.beginUncordonAsync(resourceGroupName, bareMetalMachineName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUncordon(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginUncordonAsync(resourceGroupName, bareMetalMachineName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> uncordonAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.beginUncordonAsync(resourceGroupName, bareMetalMachineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> uncordonAsync(String resourceGroupName, String bareMetalMachineName, Context context) {
        return this.beginUncordonAsync(resourceGroupName, bareMetalMachineName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner uncordon(String resourceGroupName, String bareMetalMachineName) {
        return (OperationStatusResultInner)this.uncordonAsync(resourceGroupName, bareMetalMachineName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner uncordon(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (OperationStatusResultInner)this.uncordonAsync(resourceGroupName, bareMetalMachineName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudBareMeta")
    public static interface BareMetalMachinesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.NetworkCloud/bareMetalMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineList>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachinePatchParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/cordon")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> cordon(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineCordonParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/powerOff")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> powerOff(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachinePowerOffParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/reimage")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> reimage(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/replace")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> replace(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineReplaceParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restart(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/runCommand")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> runCommand(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineRunCommandParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/runDataExtracts")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> runDataExtracts(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineRunDataExtractsParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/runReadCommands")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> runReadCommands(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineRunReadCommandsParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/uncordon")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> uncordon(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineList>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineList>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

