/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachine;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCordonParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCordonStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePatchParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePowerOffParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePowerState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineProvisioningState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineReadyState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineReplaceParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunCommandParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunDataExtractsParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunReadCommandsParameters;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HardwareInventory;
import com.azure.resourcemanager.networkcloud.models.HardwareValidationStatus;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionStatus;
import com.azure.resourcemanager.networkcloud.models.SecretRotationStatus;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BareMetalMachineImpl
implements BareMetalMachine,
BareMetalMachine.Definition,
BareMetalMachine.Update {
    private BareMetalMachineInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String bareMetalMachineName;
    private BareMetalMachinePatchParameters updateBareMetalMachineUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<String> associatedResourceIds() {
        List<String> inner = this.innerModel().associatedResourceIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String bmcConnectionString() {
        return this.innerModel().bmcConnectionString();
    }

    @Override
    public AdministrativeCredentials bmcCredentials() {
        return this.innerModel().bmcCredentials();
    }

    @Override
    public String bmcMacAddress() {
        return this.innerModel().bmcMacAddress();
    }

    @Override
    public String bootMacAddress() {
        return this.innerModel().bootMacAddress();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public BareMetalMachineCordonStatus cordonStatus() {
        return this.innerModel().cordonStatus();
    }

    @Override
    public BareMetalMachineDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public HardwareInventory hardwareInventory() {
        return this.innerModel().hardwareInventory();
    }

    @Override
    public HardwareValidationStatus hardwareValidationStatus() {
        return this.innerModel().hardwareValidationStatus();
    }

    @Override
    public List<String> hybridAksClustersAssociatedIds() {
        List<String> inner = this.innerModel().hybridAksClustersAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String kubernetesNodeName() {
        return this.innerModel().kubernetesNodeName();
    }

    @Override
    public String kubernetesVersion() {
        return this.innerModel().kubernetesVersion();
    }

    @Override
    public String machineClusterVersion() {
        return this.innerModel().machineClusterVersion();
    }

    @Override
    public String machineDetails() {
        return this.innerModel().machineDetails();
    }

    @Override
    public String machineName() {
        return this.innerModel().machineName();
    }

    @Override
    public List<String> machineRoles() {
        List<String> inner = this.innerModel().machineRoles();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String machineSkuId() {
        return this.innerModel().machineSkuId();
    }

    @Override
    public String oamIpv4Address() {
        return this.innerModel().oamIpv4Address();
    }

    @Override
    public String oamIpv6Address() {
        return this.innerModel().oamIpv6Address();
    }

    @Override
    public String osImage() {
        return this.innerModel().osImage();
    }

    @Override
    public BareMetalMachinePowerState powerState() {
        return this.innerModel().powerState();
    }

    @Override
    public BareMetalMachineProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String rackId() {
        return this.innerModel().rackId();
    }

    @Override
    public long rackSlot() {
        return this.innerModel().rackSlot();
    }

    @Override
    public BareMetalMachineReadyState readyState() {
        return this.innerModel().readyState();
    }

    @Override
    public RuntimeProtectionStatus runtimeProtectionStatus() {
        return this.innerModel().runtimeProtectionStatus();
    }

    @Override
    public List<SecretRotationStatus> secretRotationStatus() {
        List<SecretRotationStatus> inner = this.innerModel().secretRotationStatus();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String serialNumber() {
        return this.innerModel().serialNumber();
    }

    @Override
    public String serviceTag() {
        return this.innerModel().serviceTag();
    }

    @Override
    public List<String> virtualMachinesAssociatedIds() {
        List<String> inner = this.innerModel().virtualMachinesAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BareMetalMachineInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public BareMetalMachineImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public BareMetalMachine create() {
        this.innerObject = this.serviceManager.serviceClient().getBareMetalMachines().createOrUpdate(this.resourceGroupName, this.bareMetalMachineName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BareMetalMachine create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBareMetalMachines().createOrUpdate(this.resourceGroupName, this.bareMetalMachineName, this.innerModel(), context);
        return this;
    }

    BareMetalMachineImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new BareMetalMachineInner();
        this.serviceManager = serviceManager;
        this.bareMetalMachineName = name;
    }

    @Override
    public BareMetalMachineImpl update() {
        this.updateBareMetalMachineUpdateParameters = new BareMetalMachinePatchParameters();
        return this;
    }

    @Override
    public BareMetalMachine apply() {
        this.innerObject = this.serviceManager.serviceClient().getBareMetalMachines().update(this.resourceGroupName, this.bareMetalMachineName, this.updateBareMetalMachineUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public BareMetalMachine apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBareMetalMachines().update(this.resourceGroupName, this.bareMetalMachineName, this.updateBareMetalMachineUpdateParameters, context);
        return this;
    }

    BareMetalMachineImpl(BareMetalMachineInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.bareMetalMachineName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "bareMetalMachines");
    }

    @Override
    public BareMetalMachine refresh() {
        this.innerObject = (BareMetalMachineInner)((Object)this.serviceManager.serviceClient().getBareMetalMachines().getByResourceGroupWithResponse(this.resourceGroupName, this.bareMetalMachineName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BareMetalMachine refresh(Context context) {
        this.innerObject = (BareMetalMachineInner)((Object)this.serviceManager.serviceClient().getBareMetalMachines().getByResourceGroupWithResponse(this.resourceGroupName, this.bareMetalMachineName, context).getValue());
        return this;
    }

    @Override
    public OperationStatusResult cordon() {
        return this.serviceManager.bareMetalMachines().cordon(this.resourceGroupName, this.bareMetalMachineName);
    }

    @Override
    public OperationStatusResult cordon(BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        return this.serviceManager.bareMetalMachines().cordon(this.resourceGroupName, this.bareMetalMachineName, bareMetalMachineCordonParameters, context);
    }

    @Override
    public OperationStatusResult powerOff() {
        return this.serviceManager.bareMetalMachines().powerOff(this.resourceGroupName, this.bareMetalMachineName);
    }

    @Override
    public OperationStatusResult powerOff(BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        return this.serviceManager.bareMetalMachines().powerOff(this.resourceGroupName, this.bareMetalMachineName, bareMetalMachinePowerOffParameters, context);
    }

    @Override
    public OperationStatusResult reimage() {
        return this.serviceManager.bareMetalMachines().reimage(this.resourceGroupName, this.bareMetalMachineName);
    }

    @Override
    public OperationStatusResult reimage(Context context) {
        return this.serviceManager.bareMetalMachines().reimage(this.resourceGroupName, this.bareMetalMachineName, context);
    }

    @Override
    public OperationStatusResult replace() {
        return this.serviceManager.bareMetalMachines().replace(this.resourceGroupName, this.bareMetalMachineName);
    }

    @Override
    public OperationStatusResult replace(BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        return this.serviceManager.bareMetalMachines().replace(this.resourceGroupName, this.bareMetalMachineName, bareMetalMachineReplaceParameters, context);
    }

    @Override
    public OperationStatusResult restart() {
        return this.serviceManager.bareMetalMachines().restart(this.resourceGroupName, this.bareMetalMachineName);
    }

    @Override
    public OperationStatusResult restart(Context context) {
        return this.serviceManager.bareMetalMachines().restart(this.resourceGroupName, this.bareMetalMachineName, context);
    }

    @Override
    public OperationStatusResult runCommand(BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        return this.serviceManager.bareMetalMachines().runCommand(this.resourceGroupName, this.bareMetalMachineName, bareMetalMachineRunCommandParameters);
    }

    @Override
    public OperationStatusResult runCommand(BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        return this.serviceManager.bareMetalMachines().runCommand(this.resourceGroupName, this.bareMetalMachineName, bareMetalMachineRunCommandParameters, context);
    }

    @Override
    public OperationStatusResult runDataExtracts(BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        return this.serviceManager.bareMetalMachines().runDataExtracts(this.resourceGroupName, this.bareMetalMachineName, bareMetalMachineRunDataExtractsParameters);
    }

    @Override
    public OperationStatusResult runDataExtracts(BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        return this.serviceManager.bareMetalMachines().runDataExtracts(this.resourceGroupName, this.bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, context);
    }

    @Override
    public OperationStatusResult runReadCommands(BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        return this.serviceManager.bareMetalMachines().runReadCommands(this.resourceGroupName, this.bareMetalMachineName, bareMetalMachineRunReadCommandsParameters);
    }

    @Override
    public OperationStatusResult runReadCommands(BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        return this.serviceManager.bareMetalMachines().runReadCommands(this.resourceGroupName, this.bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, context);
    }

    @Override
    public OperationStatusResult start() {
        return this.serviceManager.bareMetalMachines().start(this.resourceGroupName, this.bareMetalMachineName);
    }

    @Override
    public OperationStatusResult start(Context context) {
        return this.serviceManager.bareMetalMachines().start(this.resourceGroupName, this.bareMetalMachineName, context);
    }

    @Override
    public OperationStatusResult uncordon() {
        return this.serviceManager.bareMetalMachines().uncordon(this.resourceGroupName, this.bareMetalMachineName);
    }

    @Override
    public OperationStatusResult uncordon(Context context) {
        return this.serviceManager.bareMetalMachines().uncordon(this.resourceGroupName, this.bareMetalMachineName, context);
    }

    @Override
    public BareMetalMachineImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public BareMetalMachineImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public BareMetalMachineImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public BareMetalMachineImpl withBmcConnectionString(String bmcConnectionString) {
        this.innerModel().withBmcConnectionString(bmcConnectionString);
        return this;
    }

    @Override
    public BareMetalMachineImpl withBmcCredentials(AdministrativeCredentials bmcCredentials) {
        this.innerModel().withBmcCredentials(bmcCredentials);
        return this;
    }

    @Override
    public BareMetalMachineImpl withBmcMacAddress(String bmcMacAddress) {
        this.innerModel().withBmcMacAddress(bmcMacAddress);
        return this;
    }

    @Override
    public BareMetalMachineImpl withBootMacAddress(String bootMacAddress) {
        this.innerModel().withBootMacAddress(bootMacAddress);
        return this;
    }

    @Override
    public BareMetalMachineImpl withMachineDetails(String machineDetails) {
        if (this.isInCreateMode()) {
            this.innerModel().withMachineDetails(machineDetails);
            return this;
        }
        this.updateBareMetalMachineUpdateParameters.withMachineDetails(machineDetails);
        return this;
    }

    @Override
    public BareMetalMachineImpl withMachineName(String machineName) {
        this.innerModel().withMachineName(machineName);
        return this;
    }

    @Override
    public BareMetalMachineImpl withMachineSkuId(String machineSkuId) {
        this.innerModel().withMachineSkuId(machineSkuId);
        return this;
    }

    @Override
    public BareMetalMachineImpl withRackId(String rackId) {
        this.innerModel().withRackId(rackId);
        return this;
    }

    @Override
    public BareMetalMachineImpl withRackSlot(long rackSlot) {
        this.innerModel().withRackSlot(rackSlot);
        return this;
    }

    @Override
    public BareMetalMachineImpl withSerialNumber(String serialNumber) {
        this.innerModel().withSerialNumber(serialNumber);
        return this;
    }

    @Override
    public BareMetalMachineImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBareMetalMachineUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public BareMetalMachineImpl withMachineClusterVersion(String machineClusterVersion) {
        this.innerModel().withMachineClusterVersion(machineClusterVersion);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

