/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.VolumeDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.VolumeProvisioningState;
import java.io.IOException;
import java.util.List;

public final class VolumeProperties
implements JsonSerializable<VolumeProperties> {
    private List<String> attachedTo;
    private VolumeDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private VolumeProvisioningState provisioningState;
    private String serialNumber;
    private long sizeMiB;

    public List<String> attachedTo() {
        return this.attachedTo;
    }

    public VolumeDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public VolumeProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public long sizeMiB() {
        return this.sizeMiB;
    }

    public VolumeProperties withSizeMiB(long sizeMiB) {
        this.sizeMiB = sizeMiB;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("sizeMiB", this.sizeMiB);
        return jsonWriter.writeEndObject();
    }

    public static VolumeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeProperties)jsonReader.readObject(reader -> {
            VolumeProperties deserializedVolumeProperties = new VolumeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sizeMiB".equals(fieldName)) {
                    deserializedVolumeProperties.sizeMiB = reader.getLong();
                    continue;
                }
                if ("attachedTo".equals(fieldName)) {
                    List attachedTo;
                    deserializedVolumeProperties.attachedTo = attachedTo = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedVolumeProperties.detailedStatus = VolumeDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedVolumeProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVolumeProperties.provisioningState = VolumeProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedVolumeProperties.serialNumber = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeProperties;
        });
    }
}

