/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.StorageApplianceProperties;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.RemoteVendorManagementFeature;
import com.azure.resourcemanager.networkcloud.models.RemoteVendorManagementStatus;
import com.azure.resourcemanager.networkcloud.models.SecretRotationStatus;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class StorageApplianceInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private StorageApplianceProperties innerProperties = new StorageApplianceProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(StorageApplianceInner.class);

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public StorageApplianceInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private StorageApplianceProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public StorageApplianceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public StorageApplianceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AdministrativeCredentials administratorCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorCredentials();
    }

    public StorageApplianceInner withAdministratorCredentials(AdministrativeCredentials administratorCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageApplianceProperties();
        }
        this.innerProperties().withAdministratorCredentials(administratorCredentials);
        return this;
    }

    public Long capacity() {
        return this.innerProperties() == null ? null : this.innerProperties().capacity();
    }

    public Long capacityUsed() {
        return this.innerProperties() == null ? null : this.innerProperties().capacityUsed();
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public StorageApplianceDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public String managementIpv4Address() {
        return this.innerProperties() == null ? null : this.innerProperties().managementIpv4Address();
    }

    public String manufacturer() {
        return this.innerProperties() == null ? null : this.innerProperties().manufacturer();
    }

    public String model() {
        return this.innerProperties() == null ? null : this.innerProperties().model();
    }

    public StorageApplianceProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String rackId() {
        return this.innerProperties() == null ? null : this.innerProperties().rackId();
    }

    public StorageApplianceInner withRackId(String rackId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageApplianceProperties();
        }
        this.innerProperties().withRackId(rackId);
        return this;
    }

    public long rackSlot() {
        return this.innerProperties() == null ? 0L : this.innerProperties().rackSlot();
    }

    public StorageApplianceInner withRackSlot(long rackSlot) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageApplianceProperties();
        }
        this.innerProperties().withRackSlot(rackSlot);
        return this;
    }

    public RemoteVendorManagementFeature remoteVendorManagementFeature() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteVendorManagementFeature();
    }

    public RemoteVendorManagementStatus remoteVendorManagementStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteVendorManagementStatus();
    }

    public List<SecretRotationStatus> secretRotationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().secretRotationStatus();
    }

    public String serialNumber() {
        return this.innerProperties() == null ? null : this.innerProperties().serialNumber();
    }

    public StorageApplianceInner withSerialNumber(String serialNumber) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageApplianceProperties();
        }
        this.innerProperties().withSerialNumber(serialNumber);
        return this;
    }

    public String storageApplianceSkuId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageApplianceSkuId();
    }

    public StorageApplianceInner withStorageApplianceSkuId(String storageApplianceSkuId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageApplianceProperties();
        }
        this.innerProperties().withStorageApplianceSkuId(storageApplianceSkuId);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model StorageApplianceInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model StorageApplianceInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static StorageApplianceInner fromJson(JsonReader jsonReader) throws IOException {
        return (StorageApplianceInner)((Object)jsonReader.readObject(reader -> {
            StorageApplianceInner deserializedStorageApplianceInner = new StorageApplianceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStorageApplianceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStorageApplianceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageApplianceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedStorageApplianceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedStorageApplianceInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedStorageApplianceInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageApplianceInner.innerProperties = StorageApplianceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedStorageApplianceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageApplianceInner;
        }));
    }
}

