/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.MachineSkuSlot;
import com.azure.resourcemanager.networkcloud.models.RackSkuProvisioningState;
import com.azure.resourcemanager.networkcloud.models.RackSkuType;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceSkuSlot;
import java.io.IOException;
import java.util.List;

public final class RackSkuProperties
implements JsonSerializable<RackSkuProperties> {
    private List<MachineSkuSlot> computeMachines;
    private List<MachineSkuSlot> controllerMachines;
    private String description;
    private Long maxClusterSlots;
    private RackSkuProvisioningState provisioningState;
    private RackSkuType rackType;
    private List<StorageApplianceSkuSlot> storageAppliances;
    private List<String> supportedRackSkuIds;

    public List<MachineSkuSlot> computeMachines() {
        return this.computeMachines;
    }

    public List<MachineSkuSlot> controllerMachines() {
        return this.controllerMachines;
    }

    public String description() {
        return this.description;
    }

    public Long maxClusterSlots() {
        return this.maxClusterSlots;
    }

    public RackSkuProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public RackSkuType rackType() {
        return this.rackType;
    }

    public List<StorageApplianceSkuSlot> storageAppliances() {
        return this.storageAppliances;
    }

    public List<String> supportedRackSkuIds() {
        return this.supportedRackSkuIds;
    }

    public void validate() {
        if (this.computeMachines() != null) {
            this.computeMachines().forEach(e -> e.validate());
        }
        if (this.controllerMachines() != null) {
            this.controllerMachines().forEach(e -> e.validate());
        }
        if (this.storageAppliances() != null) {
            this.storageAppliances().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RackSkuProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RackSkuProperties)jsonReader.readObject(reader -> {
            RackSkuProperties deserializedRackSkuProperties = new RackSkuProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("computeMachines".equals(fieldName)) {
                    List computeMachines;
                    deserializedRackSkuProperties.computeMachines = computeMachines = reader.readArray(reader1 -> MachineSkuSlot.fromJson(reader1));
                    continue;
                }
                if ("controllerMachines".equals(fieldName)) {
                    List controllerMachines;
                    deserializedRackSkuProperties.controllerMachines = controllerMachines = reader.readArray(reader1 -> MachineSkuSlot.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRackSkuProperties.description = reader.getString();
                    continue;
                }
                if ("maxClusterSlots".equals(fieldName)) {
                    deserializedRackSkuProperties.maxClusterSlots = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRackSkuProperties.provisioningState = RackSkuProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("rackType".equals(fieldName)) {
                    deserializedRackSkuProperties.rackType = RackSkuType.fromString(reader.getString());
                    continue;
                }
                if ("storageAppliances".equals(fieldName)) {
                    List storageAppliances;
                    deserializedRackSkuProperties.storageAppliances = storageAppliances = reader.readArray(reader1 -> StorageApplianceSkuSlot.fromJson(reader1));
                    continue;
                }
                if ("supportedRackSkuIds".equals(fieldName)) {
                    List supportedRackSkuIds;
                    deserializedRackSkuProperties.supportedRackSkuIds = supportedRackSkuIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRackSkuProperties;
        });
    }
}

