/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.BootstrapProtocol;
import com.azure.resourcemanager.networkcloud.models.MachineDisk;
import com.azure.resourcemanager.networkcloud.models.NetworkInterface;
import java.io.IOException;
import java.util.List;

public final class MachineSkuProperties
implements JsonSerializable<MachineSkuProperties> {
    private BootstrapProtocol bootstrapProtocol;
    private Long cpuCores;
    private Long cpuSockets;
    private List<MachineDisk> disks;
    private String generation;
    private String hardwareVersion;
    private Long memoryCapacityGB;
    private String model;
    private List<NetworkInterface> networkInterfaces;
    private Long totalThreads;
    private String vendor;

    public BootstrapProtocol bootstrapProtocol() {
        return this.bootstrapProtocol;
    }

    public Long cpuCores() {
        return this.cpuCores;
    }

    public Long cpuSockets() {
        return this.cpuSockets;
    }

    public List<MachineDisk> disks() {
        return this.disks;
    }

    public String generation() {
        return this.generation;
    }

    public String hardwareVersion() {
        return this.hardwareVersion;
    }

    public Long memoryCapacityGB() {
        return this.memoryCapacityGB;
    }

    public String model() {
        return this.model;
    }

    public List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public Long totalThreads() {
        return this.totalThreads;
    }

    public String vendor() {
        return this.vendor;
    }

    public void validate() {
        if (this.disks() != null) {
            this.disks().forEach(e -> e.validate());
        }
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MachineSkuProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MachineSkuProperties)jsonReader.readObject(reader -> {
            MachineSkuProperties deserializedMachineSkuProperties = new MachineSkuProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bootstrapProtocol".equals(fieldName)) {
                    deserializedMachineSkuProperties.bootstrapProtocol = BootstrapProtocol.fromString(reader.getString());
                    continue;
                }
                if ("cpuCores".equals(fieldName)) {
                    deserializedMachineSkuProperties.cpuCores = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cpuSockets".equals(fieldName)) {
                    deserializedMachineSkuProperties.cpuSockets = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("disks".equals(fieldName)) {
                    List disks;
                    deserializedMachineSkuProperties.disks = disks = reader.readArray(reader1 -> MachineDisk.fromJson(reader1));
                    continue;
                }
                if ("generation".equals(fieldName)) {
                    deserializedMachineSkuProperties.generation = reader.getString();
                    continue;
                }
                if ("hardwareVersion".equals(fieldName)) {
                    deserializedMachineSkuProperties.hardwareVersion = reader.getString();
                    continue;
                }
                if ("memoryCapacityGB".equals(fieldName)) {
                    deserializedMachineSkuProperties.memoryCapacityGB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedMachineSkuProperties.model = reader.getString();
                    continue;
                }
                if ("networkInterfaces".equals(fieldName)) {
                    List networkInterfaces;
                    deserializedMachineSkuProperties.networkInterfaces = networkInterfaces = reader.readArray(reader1 -> NetworkInterface.fromJson(reader1));
                    continue;
                }
                if ("totalThreads".equals(fieldName)) {
                    deserializedMachineSkuProperties.totalThreads = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("vendor".equals(fieldName)) {
                    deserializedMachineSkuProperties.vendor = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMachineSkuProperties;
        });
    }
}

