/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AadConfiguration;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import com.azure.resourcemanager.networkcloud.models.AvailableUpgrade;
import com.azure.resourcemanager.networkcloud.models.ControlPlaneNodeConfiguration;
import com.azure.resourcemanager.networkcloud.models.FeatureStatus;
import com.azure.resourcemanager.networkcloud.models.InitialAgentPoolConfiguration;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterNode;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.NetworkConfiguration;
import java.io.IOException;
import java.util.List;

public final class KubernetesClusterProperties
implements JsonSerializable<KubernetesClusterProperties> {
    private AadConfiguration aadConfiguration;
    private AdministratorConfiguration administratorConfiguration;
    private List<String> attachedNetworkIds;
    private List<AvailableUpgrade> availableUpgrades;
    private String clusterId;
    private String connectedClusterId;
    private String controlPlaneKubernetesVersion;
    private ControlPlaneNodeConfiguration controlPlaneNodeConfiguration;
    private KubernetesClusterDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private List<FeatureStatus> featureStatuses;
    private List<InitialAgentPoolConfiguration> initialAgentPoolConfigurations;
    private String kubernetesVersion;
    private ManagedResourceGroupConfiguration managedResourceGroupConfiguration;
    private NetworkConfiguration networkConfiguration;
    private List<KubernetesClusterNode> nodes;
    private KubernetesClusterProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(KubernetesClusterProperties.class);

    public AadConfiguration aadConfiguration() {
        return this.aadConfiguration;
    }

    public KubernetesClusterProperties withAadConfiguration(AadConfiguration aadConfiguration) {
        this.aadConfiguration = aadConfiguration;
        return this;
    }

    public AdministratorConfiguration administratorConfiguration() {
        return this.administratorConfiguration;
    }

    public KubernetesClusterProperties withAdministratorConfiguration(AdministratorConfiguration administratorConfiguration) {
        this.administratorConfiguration = administratorConfiguration;
        return this;
    }

    public List<String> attachedNetworkIds() {
        return this.attachedNetworkIds;
    }

    public List<AvailableUpgrade> availableUpgrades() {
        return this.availableUpgrades;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String connectedClusterId() {
        return this.connectedClusterId;
    }

    public String controlPlaneKubernetesVersion() {
        return this.controlPlaneKubernetesVersion;
    }

    public ControlPlaneNodeConfiguration controlPlaneNodeConfiguration() {
        return this.controlPlaneNodeConfiguration;
    }

    public KubernetesClusterProperties withControlPlaneNodeConfiguration(ControlPlaneNodeConfiguration controlPlaneNodeConfiguration) {
        this.controlPlaneNodeConfiguration = controlPlaneNodeConfiguration;
        return this;
    }

    public KubernetesClusterDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public List<FeatureStatus> featureStatuses() {
        return this.featureStatuses;
    }

    public List<InitialAgentPoolConfiguration> initialAgentPoolConfigurations() {
        return this.initialAgentPoolConfigurations;
    }

    public KubernetesClusterProperties withInitialAgentPoolConfigurations(List<InitialAgentPoolConfiguration> initialAgentPoolConfigurations) {
        this.initialAgentPoolConfigurations = initialAgentPoolConfigurations;
        return this;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public KubernetesClusterProperties withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration() {
        return this.managedResourceGroupConfiguration;
    }

    public KubernetesClusterProperties withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration managedResourceGroupConfiguration) {
        this.managedResourceGroupConfiguration = managedResourceGroupConfiguration;
        return this;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public KubernetesClusterProperties withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public List<KubernetesClusterNode> nodes() {
        return this.nodes;
    }

    public KubernetesClusterProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.aadConfiguration() != null) {
            this.aadConfiguration().validate();
        }
        if (this.administratorConfiguration() != null) {
            this.administratorConfiguration().validate();
        }
        if (this.availableUpgrades() != null) {
            this.availableUpgrades().forEach(e -> e.validate());
        }
        if (this.controlPlaneNodeConfiguration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property controlPlaneNodeConfiguration in model KubernetesClusterProperties"));
        }
        this.controlPlaneNodeConfiguration().validate();
        if (this.featureStatuses() != null) {
            this.featureStatuses().forEach(e -> e.validate());
        }
        if (this.initialAgentPoolConfigurations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property initialAgentPoolConfigurations in model KubernetesClusterProperties"));
        }
        this.initialAgentPoolConfigurations().forEach(e -> e.validate());
        if (this.kubernetesVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property kubernetesVersion in model KubernetesClusterProperties"));
        }
        if (this.managedResourceGroupConfiguration() != null) {
            this.managedResourceGroupConfiguration().validate();
        }
        if (this.networkConfiguration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkConfiguration in model KubernetesClusterProperties"));
        }
        this.networkConfiguration().validate();
        if (this.nodes() != null) {
            this.nodes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("controlPlaneNodeConfiguration", (JsonSerializable)this.controlPlaneNodeConfiguration);
        jsonWriter.writeArrayField("initialAgentPoolConfigurations", this.initialAgentPoolConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("kubernetesVersion", this.kubernetesVersion);
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        jsonWriter.writeJsonField("aadConfiguration", (JsonSerializable)this.aadConfiguration);
        jsonWriter.writeJsonField("administratorConfiguration", (JsonSerializable)this.administratorConfiguration);
        jsonWriter.writeJsonField("managedResourceGroupConfiguration", (JsonSerializable)this.managedResourceGroupConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterProperties)jsonReader.readObject(reader -> {
            KubernetesClusterProperties deserializedKubernetesClusterProperties = new KubernetesClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("controlPlaneNodeConfiguration".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.controlPlaneNodeConfiguration = ControlPlaneNodeConfiguration.fromJson(reader);
                    continue;
                }
                if ("initialAgentPoolConfigurations".equals(fieldName)) {
                    List initialAgentPoolConfigurations;
                    deserializedKubernetesClusterProperties.initialAgentPoolConfigurations = initialAgentPoolConfigurations = reader.readArray(reader1 -> InitialAgentPoolConfiguration.fromJson(reader1));
                    continue;
                }
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.kubernetesVersion = reader.getString();
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.networkConfiguration = NetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("aadConfiguration".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.aadConfiguration = AadConfiguration.fromJson(reader);
                    continue;
                }
                if ("administratorConfiguration".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.administratorConfiguration = AdministratorConfiguration.fromJson(reader);
                    continue;
                }
                if ("attachedNetworkIds".equals(fieldName)) {
                    List attachedNetworkIds;
                    deserializedKubernetesClusterProperties.attachedNetworkIds = attachedNetworkIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("availableUpgrades".equals(fieldName)) {
                    List availableUpgrades;
                    deserializedKubernetesClusterProperties.availableUpgrades = availableUpgrades = reader.readArray(reader1 -> AvailableUpgrade.fromJson(reader1));
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.clusterId = reader.getString();
                    continue;
                }
                if ("connectedClusterId".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.connectedClusterId = reader.getString();
                    continue;
                }
                if ("controlPlaneKubernetesVersion".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.controlPlaneKubernetesVersion = reader.getString();
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.detailedStatus = KubernetesClusterDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("featureStatuses".equals(fieldName)) {
                    List featureStatuses;
                    deserializedKubernetesClusterProperties.featureStatuses = featureStatuses = reader.readArray(reader1 -> FeatureStatus.fromJson(reader1));
                    continue;
                }
                if ("managedResourceGroupConfiguration".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.managedResourceGroupConfiguration = ManagedResourceGroupConfiguration.fromJson(reader);
                    continue;
                }
                if ("nodes".equals(fieldName)) {
                    List nodes;
                    deserializedKubernetesClusterProperties.nodes = nodes = reader.readArray(reader1 -> KubernetesClusterNode.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedKubernetesClusterProperties.provisioningState = KubernetesClusterProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterProperties;
        });
    }
}

