/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureAvailabilityLifecycle;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureProvisioningState;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureRequired;
import com.azure.resourcemanager.networkcloud.models.StringKeyValuePair;
import java.io.IOException;
import java.util.List;

public final class KubernetesClusterFeatureProperties
implements JsonSerializable<KubernetesClusterFeatureProperties> {
    private KubernetesClusterFeatureAvailabilityLifecycle availabilityLifecycle;
    private KubernetesClusterFeatureDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private List<StringKeyValuePair> options;
    private KubernetesClusterFeatureProvisioningState provisioningState;
    private KubernetesClusterFeatureRequired required;
    private String version;

    public KubernetesClusterFeatureAvailabilityLifecycle availabilityLifecycle() {
        return this.availabilityLifecycle;
    }

    public KubernetesClusterFeatureDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public List<StringKeyValuePair> options() {
        return this.options;
    }

    public KubernetesClusterFeatureProperties withOptions(List<StringKeyValuePair> options) {
        this.options = options;
        return this;
    }

    public KubernetesClusterFeatureProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public KubernetesClusterFeatureRequired required() {
        return this.required;
    }

    public String version() {
        return this.version;
    }

    public void validate() {
        if (this.options() != null) {
            this.options().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("options", this.options, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterFeatureProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterFeatureProperties)jsonReader.readObject(reader -> {
            KubernetesClusterFeatureProperties deserializedKubernetesClusterFeatureProperties = new KubernetesClusterFeatureProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("availabilityLifecycle".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureProperties.availabilityLifecycle = KubernetesClusterFeatureAvailabilityLifecycle.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureProperties.detailedStatus = KubernetesClusterFeatureDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("options".equals(fieldName)) {
                    List options;
                    deserializedKubernetesClusterFeatureProperties.options = options = reader.readArray(reader1 -> StringKeyValuePair.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureProperties.provisioningState = KubernetesClusterFeatureProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("required".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureProperties.required = KubernetesClusterFeatureRequired.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureProperties.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterFeatureProperties;
        });
    }
}

