/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ConsoleDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ConsoleEnabled;
import com.azure.resourcemanager.networkcloud.models.ConsoleProvisioningState;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ConsoleProperties
implements JsonSerializable<ConsoleProperties> {
    private ConsoleDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private ConsoleEnabled enabled;
    private OffsetDateTime expiration;
    private String privateLinkServiceId;
    private ConsoleProvisioningState provisioningState;
    private SshPublicKey sshPublicKey;
    private String virtualMachineAccessId;
    private static final ClientLogger LOGGER = new ClientLogger(ConsoleProperties.class);

    public ConsoleDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public ConsoleEnabled enabled() {
        return this.enabled;
    }

    public ConsoleProperties withEnabled(ConsoleEnabled enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime expiration() {
        return this.expiration;
    }

    public ConsoleProperties withExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    public String privateLinkServiceId() {
        return this.privateLinkServiceId;
    }

    public ConsoleProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SshPublicKey sshPublicKey() {
        return this.sshPublicKey;
    }

    public ConsoleProperties withSshPublicKey(SshPublicKey sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
        return this;
    }

    public String virtualMachineAccessId() {
        return this.virtualMachineAccessId;
    }

    public void validate() {
        if (this.enabled() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property enabled in model ConsoleProperties"));
        }
        if (this.sshPublicKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sshPublicKey in model ConsoleProperties"));
        }
        this.sshPublicKey().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("enabled", this.enabled == null ? null : this.enabled.toString());
        jsonWriter.writeJsonField("sshPublicKey", (JsonSerializable)this.sshPublicKey);
        jsonWriter.writeStringField("expiration", this.expiration == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiration));
        return jsonWriter.writeEndObject();
    }

    public static ConsoleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConsoleProperties)jsonReader.readObject(reader -> {
            ConsoleProperties deserializedConsoleProperties = new ConsoleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedConsoleProperties.enabled = ConsoleEnabled.fromString(reader.getString());
                    continue;
                }
                if ("sshPublicKey".equals(fieldName)) {
                    deserializedConsoleProperties.sshPublicKey = SshPublicKey.fromJson(reader);
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedConsoleProperties.detailedStatus = ConsoleDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedConsoleProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("expiration".equals(fieldName)) {
                    deserializedConsoleProperties.expiration = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("privateLinkServiceId".equals(fieldName)) {
                    deserializedConsoleProperties.privateLinkServiceId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedConsoleProperties.provisioningState = ConsoleProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("virtualMachineAccessId".equals(fieldName)) {
                    deserializedConsoleProperties.virtualMachineAccessId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConsoleProperties;
        });
    }
}

