/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ClusterMetricsConfigurationProperties
implements JsonSerializable<ClusterMetricsConfigurationProperties> {
    private long collectionInterval;
    private ClusterMetricsConfigurationDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private List<String> disabledMetrics;
    private List<String> enabledMetrics;
    private ClusterMetricsConfigurationProvisioningState provisioningState;

    public long collectionInterval() {
        return this.collectionInterval;
    }

    public ClusterMetricsConfigurationProperties withCollectionInterval(long collectionInterval) {
        this.collectionInterval = collectionInterval;
        return this;
    }

    public ClusterMetricsConfigurationDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public List<String> disabledMetrics() {
        return this.disabledMetrics;
    }

    public List<String> enabledMetrics() {
        return this.enabledMetrics;
    }

    public ClusterMetricsConfigurationProperties withEnabledMetrics(List<String> enabledMetrics) {
        this.enabledMetrics = enabledMetrics;
        return this;
    }

    public ClusterMetricsConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("collectionInterval", this.collectionInterval);
        jsonWriter.writeArrayField("enabledMetrics", this.enabledMetrics, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ClusterMetricsConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterMetricsConfigurationProperties)jsonReader.readObject(reader -> {
            ClusterMetricsConfigurationProperties deserializedClusterMetricsConfigurationProperties = new ClusterMetricsConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("collectionInterval".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationProperties.collectionInterval = reader.getLong();
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationProperties.detailedStatus = ClusterMetricsConfigurationDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("disabledMetrics".equals(fieldName)) {
                    List disabledMetrics;
                    deserializedClusterMetricsConfigurationProperties.disabledMetrics = disabledMetrics = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("enabledMetrics".equals(fieldName)) {
                    List enabledMetrics;
                    deserializedClusterMetricsConfigurationProperties.enabledMetrics = enabledMetrics = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationProperties.provisioningState = ClusterMetricsConfigurationProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterMetricsConfigurationProperties;
        });
    }
}

