/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ClusterAvailableVersion;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import java.io.IOException;
import java.util.List;

public final class ClusterManagerProperties
implements JsonSerializable<ClusterManagerProperties> {
    private String analyticsWorkspaceId;
    private List<String> availabilityZones;
    private List<ClusterAvailableVersion> clusterVersions;
    private ClusterManagerDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private String fabricControllerId;
    private ManagedResourceGroupConfiguration managedResourceGroupConfiguration;
    private ExtendedLocation managerExtendedLocation;
    private ClusterManagerProvisioningState provisioningState;
    private String vmSize;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterManagerProperties.class);

    public String analyticsWorkspaceId() {
        return this.analyticsWorkspaceId;
    }

    public ClusterManagerProperties withAnalyticsWorkspaceId(String analyticsWorkspaceId) {
        this.analyticsWorkspaceId = analyticsWorkspaceId;
        return this;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public ClusterManagerProperties withAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
        return this;
    }

    public List<ClusterAvailableVersion> clusterVersions() {
        return this.clusterVersions;
    }

    public ClusterManagerDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public String fabricControllerId() {
        return this.fabricControllerId;
    }

    public ClusterManagerProperties withFabricControllerId(String fabricControllerId) {
        this.fabricControllerId = fabricControllerId;
        return this;
    }

    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration() {
        return this.managedResourceGroupConfiguration;
    }

    public ClusterManagerProperties withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration managedResourceGroupConfiguration) {
        this.managedResourceGroupConfiguration = managedResourceGroupConfiguration;
        return this;
    }

    public ExtendedLocation managerExtendedLocation() {
        return this.managerExtendedLocation;
    }

    public ClusterManagerProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String vmSize() {
        return this.vmSize;
    }

    public ClusterManagerProperties withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public void validate() {
        if (this.clusterVersions() != null) {
            this.clusterVersions().forEach(e -> e.validate());
        }
        if (this.fabricControllerId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property fabricControllerId in model ClusterManagerProperties"));
        }
        if (this.managedResourceGroupConfiguration() != null) {
            this.managedResourceGroupConfiguration().validate();
        }
        if (this.managerExtendedLocation() != null) {
            this.managerExtendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fabricControllerId", this.fabricControllerId);
        jsonWriter.writeStringField("analyticsWorkspaceId", this.analyticsWorkspaceId);
        jsonWriter.writeArrayField("availabilityZones", this.availabilityZones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("managedResourceGroupConfiguration", (JsonSerializable)this.managedResourceGroupConfiguration);
        jsonWriter.writeStringField("vmSize", this.vmSize);
        return jsonWriter.writeEndObject();
    }

    public static ClusterManagerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterManagerProperties)jsonReader.readObject(reader -> {
            ClusterManagerProperties deserializedClusterManagerProperties = new ClusterManagerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fabricControllerId".equals(fieldName)) {
                    deserializedClusterManagerProperties.fabricControllerId = reader.getString();
                    continue;
                }
                if ("analyticsWorkspaceId".equals(fieldName)) {
                    deserializedClusterManagerProperties.analyticsWorkspaceId = reader.getString();
                    continue;
                }
                if ("availabilityZones".equals(fieldName)) {
                    List availabilityZones;
                    deserializedClusterManagerProperties.availabilityZones = availabilityZones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("clusterVersions".equals(fieldName)) {
                    List clusterVersions;
                    deserializedClusterManagerProperties.clusterVersions = clusterVersions = reader.readArray(reader1 -> ClusterAvailableVersion.fromJson(reader1));
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedClusterManagerProperties.detailedStatus = ClusterManagerDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedClusterManagerProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("managedResourceGroupConfiguration".equals(fieldName)) {
                    deserializedClusterManagerProperties.managedResourceGroupConfiguration = ManagedResourceGroupConfiguration.fromJson(reader);
                    continue;
                }
                if ("managerExtendedLocation".equals(fieldName)) {
                    deserializedClusterManagerProperties.managerExtendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterManagerProperties.provisioningState = ClusterManagerProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedClusterManagerProperties.vmSize = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterManagerProperties;
        });
    }
}

