/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VpnSiteLinkConnectionProperties;
import com.azure.resourcemanager.network.models.GatewayCustomBgpIpAddressIpConfiguration;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.azure.resourcemanager.network.models.VpnConnectionStatus;
import com.azure.resourcemanager.network.models.VpnLinkConnectionMode;
import java.io.IOException;
import java.util.List;

public final class VpnSiteLinkConnectionInner
extends SubResource {
    private VpnSiteLinkConnectionProperties innerProperties;
    private String name;
    private String etag;
    private String type;

    private VpnSiteLinkConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public VpnSiteLinkConnectionInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public VpnSiteLinkConnectionInner withId(String id) {
        super.withId(id);
        return this;
    }

    public SubResource vpnSiteLink() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnSiteLink();
    }

    public VpnSiteLinkConnectionInner withVpnSiteLink(SubResource vpnSiteLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withVpnSiteLink(vpnSiteLink);
        return this;
    }

    public Integer routingWeight() {
        return this.innerProperties() == null ? null : this.innerProperties().routingWeight();
    }

    public VpnSiteLinkConnectionInner withRoutingWeight(Integer routingWeight) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withRoutingWeight(routingWeight);
        return this;
    }

    public VpnLinkConnectionMode vpnLinkConnectionMode() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnLinkConnectionMode();
    }

    public VpnSiteLinkConnectionInner withVpnLinkConnectionMode(VpnLinkConnectionMode vpnLinkConnectionMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withVpnLinkConnectionMode(vpnLinkConnectionMode);
        return this;
    }

    public VpnConnectionStatus connectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionStatus();
    }

    public VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnConnectionProtocolType();
    }

    public VpnSiteLinkConnectionInner withVpnConnectionProtocolType(VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withVpnConnectionProtocolType(vpnConnectionProtocolType);
        return this;
    }

    public Long ingressBytesTransferred() {
        return this.innerProperties() == null ? null : this.innerProperties().ingressBytesTransferred();
    }

    public Long egressBytesTransferred() {
        return this.innerProperties() == null ? null : this.innerProperties().egressBytesTransferred();
    }

    public Integer connectionBandwidth() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionBandwidth();
    }

    public VpnSiteLinkConnectionInner withConnectionBandwidth(Integer connectionBandwidth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withConnectionBandwidth(connectionBandwidth);
        return this;
    }

    public String sharedKey() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedKey();
    }

    public VpnSiteLinkConnectionInner withSharedKey(String sharedKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withSharedKey(sharedKey);
        return this;
    }

    public Boolean enableBgp() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBgp();
    }

    public VpnSiteLinkConnectionInner withEnableBgp(Boolean enableBgp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withEnableBgp(enableBgp);
        return this;
    }

    public List<GatewayCustomBgpIpAddressIpConfiguration> vpnGatewayCustomBgpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnGatewayCustomBgpAddresses();
    }

    public VpnSiteLinkConnectionInner withVpnGatewayCustomBgpAddresses(List<GatewayCustomBgpIpAddressIpConfiguration> vpnGatewayCustomBgpAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withVpnGatewayCustomBgpAddresses(vpnGatewayCustomBgpAddresses);
        return this;
    }

    public Boolean usePolicyBasedTrafficSelectors() {
        return this.innerProperties() == null ? null : this.innerProperties().usePolicyBasedTrafficSelectors();
    }

    public VpnSiteLinkConnectionInner withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withUsePolicyBasedTrafficSelectors(usePolicyBasedTrafficSelectors);
        return this;
    }

    public List<IpsecPolicy> ipsecPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().ipsecPolicies();
    }

    public VpnSiteLinkConnectionInner withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withIpsecPolicies(ipsecPolicies);
        return this;
    }

    public Boolean enableRateLimiting() {
        return this.innerProperties() == null ? null : this.innerProperties().enableRateLimiting();
    }

    public VpnSiteLinkConnectionInner withEnableRateLimiting(Boolean enableRateLimiting) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withEnableRateLimiting(enableRateLimiting);
        return this;
    }

    public Boolean useLocalAzureIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().useLocalAzureIpAddress();
    }

    public VpnSiteLinkConnectionInner withUseLocalAzureIpAddress(Boolean useLocalAzureIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withUseLocalAzureIpAddress(useLocalAzureIpAddress);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<SubResource> ingressNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().ingressNatRules();
    }

    public VpnSiteLinkConnectionInner withIngressNatRules(List<SubResource> ingressNatRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withIngressNatRules(ingressNatRules);
        return this;
    }

    public List<SubResource> egressNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().egressNatRules();
    }

    public VpnSiteLinkConnectionInner withEgressNatRules(List<SubResource> egressNatRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withEgressNatRules(egressNatRules);
        return this;
    }

    public Integer dpdTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().dpdTimeoutSeconds();
    }

    public VpnSiteLinkConnectionInner withDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkConnectionProperties();
        }
        this.innerProperties().withDpdTimeoutSeconds(dpdTimeoutSeconds);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static VpnSiteLinkConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (VpnSiteLinkConnectionInner)((Object)jsonReader.readObject(reader -> {
            VpnSiteLinkConnectionInner deserializedVpnSiteLinkConnectionInner = new VpnSiteLinkConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionInner.innerProperties = VpnSiteLinkConnectionProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVpnSiteLinkConnectionInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnSiteLinkConnectionInner;
        }));
    }
}

