/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.network.fluent.models.PrivateLinkServiceIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.PrivateLinkServiceProperties;
import com.azure.resourcemanager.network.models.AccessMode;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.PrivateLinkServicePropertiesAutoApproval;
import com.azure.resourcemanager.network.models.PrivateLinkServicePropertiesVisibility;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PrivateLinkServiceInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private PrivateLinkServiceProperties innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public PrivateLinkServiceInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private PrivateLinkServiceProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public PrivateLinkServiceInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public PrivateLinkServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PrivateLinkServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancerFrontendIpConfigurations();
    }

    public PrivateLinkServiceInner withLoadBalancerFrontendIpConfigurations(List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withLoadBalancerFrontendIpConfigurations(loadBalancerFrontendIpConfigurations);
        return this;
    }

    public List<PrivateLinkServiceIpConfigurationInner> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public PrivateLinkServiceInner withIpConfigurations(List<PrivateLinkServiceIpConfigurationInner> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public String destinationIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationIpAddress();
    }

    public PrivateLinkServiceInner withDestinationIpAddress(String destinationIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withDestinationIpAddress(destinationIpAddress);
        return this;
    }

    public AccessMode accessMode() {
        return this.innerProperties() == null ? null : this.innerProperties().accessMode();
    }

    public PrivateLinkServiceInner withAccessMode(AccessMode accessMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withAccessMode(accessMode);
        return this;
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().networkInterfaces();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public PrivateLinkServicePropertiesVisibility visibility() {
        return this.innerProperties() == null ? null : this.innerProperties().visibility();
    }

    public PrivateLinkServiceInner withVisibility(PrivateLinkServicePropertiesVisibility visibility) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withVisibility(visibility);
        return this;
    }

    public PrivateLinkServicePropertiesAutoApproval autoApproval() {
        return this.innerProperties() == null ? null : this.innerProperties().autoApproval();
    }

    public PrivateLinkServiceInner withAutoApproval(PrivateLinkServicePropertiesAutoApproval autoApproval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withAutoApproval(autoApproval);
        return this;
    }

    public List<String> fqdns() {
        return this.innerProperties() == null ? null : this.innerProperties().fqdns();
    }

    public PrivateLinkServiceInner withFqdns(List<String> fqdns) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withFqdns(fqdns);
        return this;
    }

    public String alias() {
        return this.innerProperties() == null ? null : this.innerProperties().alias();
    }

    public Boolean enableProxyProtocol() {
        return this.innerProperties() == null ? null : this.innerProperties().enableProxyProtocol();
    }

    public PrivateLinkServiceInner withEnableProxyProtocol(Boolean enableProxyProtocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withEnableProxyProtocol(enableProxyProtocol);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkServiceInner fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkServiceInner)((Object)jsonReader.readObject(reader -> {
            PrivateLinkServiceInner deserializedPrivateLinkServiceInner = new PrivateLinkServiceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPrivateLinkServiceInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.innerProperties = PrivateLinkServiceProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkServiceInner;
        }));
    }
}

