/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ReachabilityAnalysisIntentsClient;
import com.azure.resourcemanager.network.fluent.models.ReachabilityAnalysisIntentInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ReachabilityAnalysisIntentListResult;
import reactor.core.publisher.Mono;

public final class ReachabilityAnalysisIntentsClientImpl
implements ReachabilityAnalysisIntentsClient {
    private final ReachabilityAnalysisIntentsService service;
    private final NetworkManagementClientImpl client;

    ReachabilityAnalysisIntentsClientImpl(NetworkManagementClientImpl client) {
        this.service = (ReachabilityAnalysisIntentsService)RestProxy.create(ReachabilityAnalysisIntentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisIntentInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2025-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReachabilityAnalysisIntentListResult)res.getValue()).value(), ((ReachabilityAnalysisIntentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisIntentInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2025-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReachabilityAnalysisIntentListResult)res.getValue()).value(), ((ReachabilityAnalysisIntentListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ReachabilityAnalysisIntentInner> listAsync(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ReachabilityAnalysisIntentInner> listAsync(String resourceGroupName, String networkManagerName, String workspaceName) {
        String skipToken = null;
        Integer skip = null;
        Integer top = null;
        String sortKey = null;
        String sortValue = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ReachabilityAnalysisIntentInner> listAsync(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ReachabilityAnalysisIntentInner> list(String resourceGroupName, String networkManagerName, String workspaceName) {
        String skipToken = null;
        Integer skip = null;
        Integer top = null;
        String sortKey = null;
        String sortValue = null;
        return new PagedIterable(this.listAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ReachabilityAnalysisIntentInner> list(String resourceGroupName, String networkManagerName, String workspaceName, String skipToken, Integer skip, Integer top, String sortKey, String sortValue, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkManagerName, workspaceName, skipToken, skip, top, sortKey, sortValue, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReachabilityAnalysisIntentInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2025-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ReachabilityAnalysisIntentInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2025-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReachabilityAnalysisIntentInner> getAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName) {
        return this.getWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ReachabilityAnalysisIntentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReachabilityAnalysisIntentInner> getWithResponse(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReachabilityAnalysisIntentInner get(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName) {
        return (ReachabilityAnalysisIntentInner)((Object)this.getWithResponse(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReachabilityAnalysisIntentInner>> createWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2025-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ReachabilityAnalysisIntentInner>> createWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2025-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReachabilityAnalysisIntentInner> createAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body) {
        return this.createWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, body).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ReachabilityAnalysisIntentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReachabilityAnalysisIntentInner> createWithResponse(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReachabilityAnalysisIntentInner create(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, ReachabilityAnalysisIntentInner body) {
        return (ReachabilityAnalysisIntentInner)((Object)this.createWithResponse(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, body, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2025-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (reachabilityAnalysisIntentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reachabilityAnalysisIntentName is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2025-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName) {
        return this.deleteWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String workspaceName, String reachabilityAnalysisIntentName) {
        this.deleteWithResponse(resourceGroupName, networkManagerName, workspaceName, reachabilityAnalysisIntentName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisIntentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReachabilityAnalysisIntentListResult)res.getValue()).value(), ((ReachabilityAnalysisIntentListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReachabilityAnalysisIntentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReachabilityAnalysisIntentListResult)res.getValue()).value(), ((ReachabilityAnalysisIntentListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementClientReachabilityAnalysisIntents")
    public static interface ReachabilityAnalysisIntentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisIntents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReachabilityAnalysisIntentListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="workspaceName") String var6, @QueryParam(value="skipToken") String var7, @QueryParam(value="skip") Integer var8, @QueryParam(value="top") Integer var9, @QueryParam(value="sortKey") String var10, @QueryParam(value="sortValue") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisIntents/{reachabilityAnalysisIntentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReachabilityAnalysisIntentInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="reachabilityAnalysisIntentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisIntents/{reachabilityAnalysisIntentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReachabilityAnalysisIntentInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="reachabilityAnalysisIntentName") String var7, @BodyParam(value="application/json") ReachabilityAnalysisIntentInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/verifierWorkspaces/{workspaceName}/reachabilityAnalysisIntents/{reachabilityAnalysisIntentName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="workspaceName") String var6, @PathParam(value="reachabilityAnalysisIntentName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReachabilityAnalysisIntentListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

