/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.implementation.PacketCaptureImpl;
import com.azure.resourcemanager.network.models.PCFilter;
import com.azure.resourcemanager.network.models.PacketCapture;
import com.azure.resourcemanager.network.models.PacketCaptureFilter;
import com.azure.resourcemanager.network.models.PcProtocol;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.util.List;

class PCFilterImpl
extends IndexableWrapperImpl<PacketCaptureFilter>
implements PCFilter,
PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> {
    private static final String DELIMITER = ";";
    private static final String RANGE_DELIMITER = "-";
    private PacketCaptureImpl parent;

    PCFilterImpl(PacketCaptureFilter inner, PacketCaptureImpl parent) {
        super((Object)inner);
        this.parent = parent;
    }

    @Override
    public PcProtocol protocol() {
        return ((PacketCaptureFilter)this.innerModel()).protocol();
    }

    @Override
    public String localIpAddress() {
        return ((PacketCaptureFilter)this.innerModel()).localIpAddress();
    }

    @Override
    public String remoteIpAddress() {
        return ((PacketCaptureFilter)this.innerModel()).remoteIpAddress();
    }

    @Override
    public String localPort() {
        return ((PacketCaptureFilter)this.innerModel()).localPort();
    }

    @Override
    public String remotePort() {
        return ((PacketCaptureFilter)this.innerModel()).remotePort();
    }

    @Override
    public PCFilterImpl withProtocol(PcProtocol protocol) {
        ((PacketCaptureFilter)this.innerModel()).withProtocol(protocol);
        return this;
    }

    public PCFilterImpl withLocalIpAddress(String ipAddress) {
        ((PacketCaptureFilter)this.innerModel()).withLocalIpAddress(ipAddress);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalIpAddressesRange(String startIpAddress, String endIpAddress) {
        ((PacketCaptureFilter)this.innerModel()).withLocalIpAddress(startIpAddress + RANGE_DELIMITER + endIpAddress);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalIpAddresses(List<String> ipAddresses) {
        StringBuilder ipAddressesString = new StringBuilder();
        for (String ipAddress : ipAddresses) {
            ipAddressesString.append(ipAddress).append(DELIMITER);
        }
        ((PacketCaptureFilter)this.innerModel()).withLocalIpAddress(ipAddressesString.substring(0, ipAddressesString.length() - 1));
        return this;
    }

    public PCFilterImpl withRemoteIpAddress(String ipAddress) {
        ((PacketCaptureFilter)this.innerModel()).withRemoteIpAddress(ipAddress);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemoteIpAddressesRange(String startIpAddress, String endIpAddress) {
        ((PacketCaptureFilter)this.innerModel()).withRemoteIpAddress(startIpAddress + RANGE_DELIMITER + endIpAddress);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemoteIpAddresses(List<String> ipAddresses) {
        StringBuilder ipAddressesString = new StringBuilder();
        for (String ipAddress : ipAddresses) {
            ipAddressesString.append(ipAddress).append(DELIMITER);
        }
        ((PacketCaptureFilter)this.innerModel()).withRemoteIpAddress(ipAddressesString.substring(0, ipAddressesString.length() - 1));
        return this;
    }

    public PacketCapture parent() {
        return this.parent;
    }

    public PacketCaptureImpl attach() {
        this.parent.attachPCFilter(this);
        return this.parent;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalPort(int port) {
        ((PacketCaptureFilter)this.innerModel()).withLocalPort(String.valueOf(port));
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalPortRange(int startPort, int endPort) {
        ((PacketCaptureFilter)this.innerModel()).withLocalPort(startPort + RANGE_DELIMITER + endPort);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withLocalPorts(List<Integer> ports) {
        StringBuilder portsString = new StringBuilder();
        for (int port : ports) {
            portsString.append(port).append(DELIMITER);
        }
        ((PacketCaptureFilter)this.innerModel()).withLocalPort(portsString.substring(0, portsString.length() - 1));
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemotePort(int port) {
        ((PacketCaptureFilter)this.innerModel()).withRemotePort(String.valueOf(port));
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemotePortRange(int startPort, int endPort) {
        ((PacketCaptureFilter)this.innerModel()).withRemotePort(startPort + RANGE_DELIMITER + endPort);
        return this;
    }

    @Override
    public PCFilter.Definition<PacketCapture.DefinitionStages.WithCreate> withRemotePorts(List<Integer> ports) {
        StringBuilder portsString = new StringBuilder();
        for (int port : ports) {
            portsString.append(port).append(DELIMITER);
        }
        ((PacketCaptureFilter)this.innerModel()).withRemotePort(portsString.substring(0, portsString.length() - 1));
        return this;
    }
}

