/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteTableUsageMode;
import java.io.IOException;

public final class NetworkManagerRoutingConfigurationPropertiesFormat
implements JsonSerializable<NetworkManagerRoutingConfigurationPropertiesFormat> {
    private String description;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private RouteTableUsageMode routeTableUsageMode;

    public String description() {
        return this.description;
    }

    public NetworkManagerRoutingConfigurationPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public RouteTableUsageMode routeTableUsageMode() {
        return this.routeTableUsageMode;
    }

    public NetworkManagerRoutingConfigurationPropertiesFormat withRouteTableUsageMode(RouteTableUsageMode routeTableUsageMode) {
        this.routeTableUsageMode = routeTableUsageMode;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("routeTableUsageMode", this.routeTableUsageMode == null ? null : this.routeTableUsageMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerRoutingConfigurationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkManagerRoutingConfigurationPropertiesFormat)jsonReader.readObject(reader -> {
            NetworkManagerRoutingConfigurationPropertiesFormat deserializedNetworkManagerRoutingConfigurationPropertiesFormat = new NetworkManagerRoutingConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationPropertiesFormat.description = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("routeTableUsageMode".equals(fieldName)) {
                    deserializedNetworkManagerRoutingConfigurationPropertiesFormat.routeTableUsageMode = RouteTableUsageMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerRoutingConfigurationPropertiesFormat;
        });
    }
}

