/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.BgpConnectionProperties;
import com.azure.resourcemanager.network.models.HubBgpConnectionStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class BgpConnectionInner
extends SubResource {
    private BgpConnectionProperties innerProperties;
    private String name;
    private String etag;
    private String type;

    private BgpConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public BgpConnectionInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public BgpConnectionInner withId(String id) {
        super.withId(id);
        return this;
    }

    public Long peerAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().peerAsn();
    }

    public BgpConnectionInner withPeerAsn(Long peerAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpConnectionProperties();
        }
        this.innerProperties().withPeerAsn(peerAsn);
        return this;
    }

    public String peerIp() {
        return this.innerProperties() == null ? null : this.innerProperties().peerIp();
    }

    public BgpConnectionInner withPeerIp(String peerIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpConnectionProperties();
        }
        this.innerProperties().withPeerIp(peerIp);
        return this;
    }

    public SubResource hubVirtualNetworkConnection() {
        return this.innerProperties() == null ? null : this.innerProperties().hubVirtualNetworkConnection();
    }

    public BgpConnectionInner withHubVirtualNetworkConnection(SubResource hubVirtualNetworkConnection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BgpConnectionProperties();
        }
        this.innerProperties().withHubVirtualNetworkConnection(hubVirtualNetworkConnection);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public HubBgpConnectionStatus connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static BgpConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (BgpConnectionInner)((Object)jsonReader.readObject(reader -> {
            BgpConnectionInner deserializedBgpConnectionInner = new BgpConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBgpConnectionInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBgpConnectionInner.innerProperties = BgpConnectionProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBgpConnectionInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedBgpConnectionInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBgpConnectionInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBgpConnectionInner;
        }));
    }
}

