/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayBackendSettingsPropertiesFormat
implements JsonSerializable<ApplicationGatewayBackendSettingsPropertiesFormat> {
    private Integer port;
    private ApplicationGatewayProtocol protocol;
    private Integer timeout;
    private SubResource probe;
    private List<SubResource> trustedRootCertificates;
    private String hostname;
    private Boolean pickHostnameFromBackendAddress;
    private Boolean enableL4ClientIpPreservation;
    private ProvisioningState provisioningState;

    public Integer port() {
        return this.port;
    }

    public ApplicationGatewayBackendSettingsPropertiesFormat withPort(Integer port) {
        this.port = port;
        return this;
    }

    public ApplicationGatewayProtocol protocol() {
        return this.protocol;
    }

    public ApplicationGatewayBackendSettingsPropertiesFormat withProtocol(ApplicationGatewayProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public ApplicationGatewayBackendSettingsPropertiesFormat withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public SubResource probe() {
        return this.probe;
    }

    public ApplicationGatewayBackendSettingsPropertiesFormat withProbe(SubResource probe) {
        this.probe = probe;
        return this;
    }

    public List<SubResource> trustedRootCertificates() {
        return this.trustedRootCertificates;
    }

    public ApplicationGatewayBackendSettingsPropertiesFormat withTrustedRootCertificates(List<SubResource> trustedRootCertificates) {
        this.trustedRootCertificates = trustedRootCertificates;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public ApplicationGatewayBackendSettingsPropertiesFormat withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Boolean pickHostnameFromBackendAddress() {
        return this.pickHostnameFromBackendAddress;
    }

    public ApplicationGatewayBackendSettingsPropertiesFormat withPickHostnameFromBackendAddress(Boolean pickHostnameFromBackendAddress) {
        this.pickHostnameFromBackendAddress = pickHostnameFromBackendAddress;
        return this;
    }

    public Boolean enableL4ClientIpPreservation() {
        return this.enableL4ClientIpPreservation;
    }

    public ApplicationGatewayBackendSettingsPropertiesFormat withEnableL4ClientIpPreservation(Boolean enableL4ClientIpPreservation) {
        this.enableL4ClientIpPreservation = enableL4ClientIpPreservation;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeNumberField("timeout", (Number)this.timeout);
        jsonWriter.writeJsonField("probe", (JsonSerializable)this.probe);
        jsonWriter.writeArrayField("trustedRootCertificates", this.trustedRootCertificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeBooleanField("pickHostNameFromBackendAddress", this.pickHostnameFromBackendAddress);
        jsonWriter.writeBooleanField("enableL4ClientIpPreservation", this.enableL4ClientIpPreservation);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayBackendSettingsPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayBackendSettingsPropertiesFormat)jsonReader.readObject(reader -> {
            ApplicationGatewayBackendSettingsPropertiesFormat deserializedApplicationGatewayBackendSettingsPropertiesFormat = new ApplicationGatewayBackendSettingsPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("port".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.protocol = ApplicationGatewayProtocol.fromString(reader.getString());
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.timeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("probe".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.probe = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("trustedRootCertificates".equals(fieldName)) {
                    List trustedRootCertificates;
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.trustedRootCertificates = trustedRootCertificates = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.hostname = reader.getString();
                    continue;
                }
                if ("pickHostNameFromBackendAddress".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.pickHostnameFromBackendAddress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableL4ClientIpPreservation".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.enableL4ClientIpPreservation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayBackendSettingsPropertiesFormat;
        });
    }
}

