/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.SecurityUserRuleCollectionPropertiesFormat;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityUserGroupItem;
import java.io.IOException;
import java.util.List;

public final class SecurityUserRuleCollectionInner
extends ChildResource {
    private SecurityUserRuleCollectionPropertiesFormat innerProperties;
    private SystemData systemData;
    private String etag;
    private String type;
    private String name;
    private String id;

    private SecurityUserRuleCollectionPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public SecurityUserRuleCollectionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityUserRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public List<SecurityUserGroupItem> appliesToGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().appliesToGroups();
    }

    public SecurityUserRuleCollectionInner withAppliesToGroups(List<SecurityUserGroupItem> appliesToGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityUserRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withAppliesToGroups(appliesToGroups);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SecurityUserRuleCollectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityUserRuleCollectionInner)((Object)jsonReader.readObject(reader -> {
            SecurityUserRuleCollectionInner deserializedSecurityUserRuleCollectionInner = new SecurityUserRuleCollectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionInner.innerProperties = SecurityUserRuleCollectionPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityUserRuleCollectionInner;
        }));
    }
}

