/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspLinkReferenceProperties;
import com.azure.resourcemanager.network.models.NspLinkProvisioningState;
import com.azure.resourcemanager.network.models.NspLinkStatus;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;
import java.util.List;

public final class NspLinkReferenceInner
extends SecurityPerimeterProxyResource {
    private NspLinkReferenceProperties innerProperties;
    private SecurityPerimeterSystemData systemData;
    private String type;
    private String name;
    private String id;

    private NspLinkReferenceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public NspLinkProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String remotePerimeterResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterResourceId();
    }

    public String remotePerimeterGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterGuid();
    }

    public String remotePerimeterLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().remotePerimeterLocation();
    }

    public List<String> localInboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().localInboundProfiles();
    }

    public NspLinkReferenceInner withLocalInboundProfiles(List<String> localInboundProfiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkReferenceProperties();
        }
        this.innerProperties().withLocalInboundProfiles(localInboundProfiles);
        return this;
    }

    public List<String> localOutboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().localOutboundProfiles();
    }

    public List<String> remoteInboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteInboundProfiles();
    }

    public List<String> remoteOutboundProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().remoteOutboundProfiles();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public NspLinkStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public NspLinkReferenceInner withStatus(NspLinkStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLinkReferenceProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NspLinkReferenceInner fromJson(JsonReader jsonReader) throws IOException {
        return (NspLinkReferenceInner)((Object)jsonReader.readObject(reader -> {
            NspLinkReferenceInner deserializedNspLinkReferenceInner = new NspLinkReferenceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNspLinkReferenceInner.innerProperties = NspLinkReferenceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspLinkReferenceInner;
        }));
    }
}

