/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkVirtualAppliancePropertiesFormat;
import com.azure.resourcemanager.network.models.DelegationProperties;
import com.azure.resourcemanager.network.models.InternetIngressPublicIpsProperties;
import com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.azure.resourcemanager.network.models.NetworkVirtualAppliancePropertiesFormatNetworkProfile;
import com.azure.resourcemanager.network.models.NvaInterfaceConfigurationsProperties;
import com.azure.resourcemanager.network.models.PartnerManagedResourceProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualApplianceAdditionalNicProperties;
import com.azure.resourcemanager.network.models.VirtualApplianceNicProperties;
import com.azure.resourcemanager.network.models.VirtualApplianceSkuProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class NetworkVirtualApplianceInner
extends Resource {
    private NetworkVirtualAppliancePropertiesFormat innerProperties;
    private ManagedServiceIdentity identity;
    private String etag;
    private String id;
    private String type;
    private String name;

    private NetworkVirtualAppliancePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public NetworkVirtualApplianceInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public NetworkVirtualApplianceInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public NetworkVirtualApplianceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NetworkVirtualApplianceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public VirtualApplianceSkuProperties nvaSku() {
        return this.innerProperties() == null ? null : this.innerProperties().nvaSku();
    }

    public NetworkVirtualApplianceInner withNvaSku(VirtualApplianceSkuProperties nvaSku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withNvaSku(nvaSku);
        return this;
    }

    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    public List<String> bootStrapConfigurationBlobs() {
        return this.innerProperties() == null ? null : this.innerProperties().bootStrapConfigurationBlobs();
    }

    public NetworkVirtualApplianceInner withBootStrapConfigurationBlobs(List<String> bootStrapConfigurationBlobs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withBootStrapConfigurationBlobs(bootStrapConfigurationBlobs);
        return this;
    }

    public SubResource virtualHub() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHub();
    }

    public NetworkVirtualApplianceInner withVirtualHub(SubResource virtualHub) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withVirtualHub(virtualHub);
        return this;
    }

    public List<String> cloudInitConfigurationBlobs() {
        return this.innerProperties() == null ? null : this.innerProperties().cloudInitConfigurationBlobs();
    }

    public NetworkVirtualApplianceInner withCloudInitConfigurationBlobs(List<String> cloudInitConfigurationBlobs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withCloudInitConfigurationBlobs(cloudInitConfigurationBlobs);
        return this;
    }

    public String cloudInitConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().cloudInitConfiguration();
    }

    public NetworkVirtualApplianceInner withCloudInitConfiguration(String cloudInitConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withCloudInitConfiguration(cloudInitConfiguration);
        return this;
    }

    public Long virtualApplianceAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualApplianceAsn();
    }

    public NetworkVirtualApplianceInner withVirtualApplianceAsn(Long virtualApplianceAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withVirtualApplianceAsn(virtualApplianceAsn);
        return this;
    }

    public String sshPublicKey() {
        return this.innerProperties() == null ? null : this.innerProperties().sshPublicKey();
    }

    public NetworkVirtualApplianceInner withSshPublicKey(String sshPublicKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withSshPublicKey(sshPublicKey);
        return this;
    }

    public List<VirtualApplianceNicProperties> virtualApplianceNics() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualApplianceNics();
    }

    public NetworkVirtualAppliancePropertiesFormatNetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    public NetworkVirtualApplianceInner withNetworkProfile(NetworkVirtualAppliancePropertiesFormatNetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    public List<VirtualApplianceAdditionalNicProperties> additionalNics() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalNics();
    }

    public NetworkVirtualApplianceInner withAdditionalNics(List<VirtualApplianceAdditionalNicProperties> additionalNics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withAdditionalNics(additionalNics);
        return this;
    }

    public List<InternetIngressPublicIpsProperties> internetIngressPublicIps() {
        return this.innerProperties() == null ? null : this.innerProperties().internetIngressPublicIps();
    }

    public NetworkVirtualApplianceInner withInternetIngressPublicIps(List<InternetIngressPublicIpsProperties> internetIngressPublicIps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withInternetIngressPublicIps(internetIngressPublicIps);
        return this;
    }

    public List<SubResource> virtualApplianceSites() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualApplianceSites();
    }

    public List<SubResource> virtualApplianceConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualApplianceConnections();
    }

    public List<SubResource> inboundSecurityRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundSecurityRules();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String deploymentType() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentType();
    }

    public DelegationProperties delegation() {
        return this.innerProperties() == null ? null : this.innerProperties().delegation();
    }

    public NetworkVirtualApplianceInner withDelegation(DelegationProperties delegation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withDelegation(delegation);
        return this;
    }

    public PartnerManagedResourceProperties partnerManagedResource() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerManagedResource();
    }

    public NetworkVirtualApplianceInner withPartnerManagedResource(PartnerManagedResourceProperties partnerManagedResource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withPartnerManagedResource(partnerManagedResource);
        return this;
    }

    public List<NvaInterfaceConfigurationsProperties> nvaInterfaceConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().nvaInterfaceConfigurations();
    }

    public NetworkVirtualApplianceInner withNvaInterfaceConfigurations(List<NvaInterfaceConfigurationsProperties> nvaInterfaceConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkVirtualAppliancePropertiesFormat();
        }
        this.innerProperties().withNvaInterfaceConfigurations(nvaInterfaceConfigurations);
        return this;
    }

    public String privateIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAddress();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static NetworkVirtualApplianceInner fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkVirtualApplianceInner)((Object)jsonReader.readObject(reader -> {
            NetworkVirtualApplianceInner deserializedNetworkVirtualApplianceInner = new NetworkVirtualApplianceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetworkVirtualApplianceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceInner.innerProperties = NetworkVirtualAppliancePropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkVirtualApplianceInner;
        }));
    }
}

