/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DdosSettingsProtectionMode;
import java.io.IOException;

public final class DdosSettings
implements JsonSerializable<DdosSettings> {
    private DdosSettingsProtectionMode protectionMode;
    private SubResource ddosProtectionPlan;

    public DdosSettingsProtectionMode protectionMode() {
        return this.protectionMode;
    }

    public DdosSettings withProtectionMode(DdosSettingsProtectionMode protectionMode) {
        this.protectionMode = protectionMode;
        return this;
    }

    public SubResource ddosProtectionPlan() {
        return this.ddosProtectionPlan;
    }

    public DdosSettings withDdosProtectionPlan(SubResource ddosProtectionPlan) {
        this.ddosProtectionPlan = ddosProtectionPlan;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protectionMode", this.protectionMode == null ? null : this.protectionMode.toString());
        jsonWriter.writeJsonField("ddosProtectionPlan", (JsonSerializable)this.ddosProtectionPlan);
        return jsonWriter.writeEndObject();
    }

    public static DdosSettings fromJson(JsonReader jsonReader) throws IOException {
        return (DdosSettings)jsonReader.readObject(reader -> {
            DdosSettings deserializedDdosSettings = new DdosSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protectionMode".equals(fieldName)) {
                    deserializedDdosSettings.protectionMode = DdosSettingsProtectionMode.fromString(reader.getString());
                    continue;
                }
                if ("ddosProtectionPlan".equals(fieldName)) {
                    deserializedDdosSettings.ddosProtectionPlan = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDdosSettings;
        });
    }
}

