/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AzureFirewallPublicIpAddress;
import java.io.IOException;
import java.util.List;

public final class HubPublicIpAddresses
implements JsonSerializable<HubPublicIpAddresses> {
    private List<AzureFirewallPublicIpAddress> addresses;
    private Integer count;

    public List<AzureFirewallPublicIpAddress> addresses() {
        return this.addresses;
    }

    public HubPublicIpAddresses withAddresses(List<AzureFirewallPublicIpAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public Integer count() {
        return this.count;
    }

    public HubPublicIpAddresses withCount(Integer count) {
        this.count = count;
        return this;
    }

    public void validate() {
        if (this.addresses() != null) {
            this.addresses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("addresses", this.addresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("count", (Number)this.count);
        return jsonWriter.writeEndObject();
    }

    public static HubPublicIpAddresses fromJson(JsonReader jsonReader) throws IOException {
        return (HubPublicIpAddresses)jsonReader.readObject(reader -> {
            HubPublicIpAddresses deserializedHubPublicIpAddresses = new HubPublicIpAddresses();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("addresses".equals(fieldName)) {
                    List addresses;
                    deserializedHubPublicIpAddresses.addresses = addresses = reader.readArray(reader1 -> AzureFirewallPublicIpAddress.fromJson(reader1));
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedHubPublicIpAddresses.count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHubPublicIpAddresses;
        });
    }
}

