/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.AzureFirewallPropertiesFormat;
import com.azure.resourcemanager.network.models.AzureFirewallApplicationRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallAutoscaleConfiguration;
import com.azure.resourcemanager.network.models.AzureFirewallIpConfiguration;
import com.azure.resourcemanager.network.models.AzureFirewallIpGroups;
import com.azure.resourcemanager.network.models.AzureFirewallNatRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallNetworkRuleCollection;
import com.azure.resourcemanager.network.models.AzureFirewallSku;
import com.azure.resourcemanager.network.models.AzureFirewallThreatIntelMode;
import com.azure.resourcemanager.network.models.HubIpAddresses;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AzureFirewallInner
extends Resource {
    private AzureFirewallPropertiesFormat innerProperties;
    private List<String> zones;
    private String etag;
    private String id;
    private String type;
    private String name;

    private AzureFirewallPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public AzureFirewallInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public AzureFirewallInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public AzureFirewallInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AzureFirewallInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<AzureFirewallApplicationRuleCollection> applicationRuleCollections() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationRuleCollections();
    }

    public AzureFirewallInner withApplicationRuleCollections(List<AzureFirewallApplicationRuleCollection> applicationRuleCollections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withApplicationRuleCollections(applicationRuleCollections);
        return this;
    }

    public List<AzureFirewallNatRuleCollection> natRuleCollections() {
        return this.innerProperties() == null ? null : this.innerProperties().natRuleCollections();
    }

    public AzureFirewallInner withNatRuleCollections(List<AzureFirewallNatRuleCollection> natRuleCollections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withNatRuleCollections(natRuleCollections);
        return this;
    }

    public List<AzureFirewallNetworkRuleCollection> networkRuleCollections() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleCollections();
    }

    public AzureFirewallInner withNetworkRuleCollections(List<AzureFirewallNetworkRuleCollection> networkRuleCollections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withNetworkRuleCollections(networkRuleCollections);
        return this;
    }

    public List<AzureFirewallIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public AzureFirewallInner withIpConfigurations(List<AzureFirewallIpConfiguration> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    public AzureFirewallIpConfiguration managementIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().managementIpConfiguration();
    }

    public AzureFirewallInner withManagementIpConfiguration(AzureFirewallIpConfiguration managementIpConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withManagementIpConfiguration(managementIpConfiguration);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public AzureFirewallThreatIntelMode threatIntelMode() {
        return this.innerProperties() == null ? null : this.innerProperties().threatIntelMode();
    }

    public AzureFirewallInner withThreatIntelMode(AzureFirewallThreatIntelMode threatIntelMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withThreatIntelMode(threatIntelMode);
        return this;
    }

    public SubResource virtualHub() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHub();
    }

    public AzureFirewallInner withVirtualHub(SubResource virtualHub) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withVirtualHub(virtualHub);
        return this;
    }

    public SubResource firewallPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().firewallPolicy();
    }

    public AzureFirewallInner withFirewallPolicy(SubResource firewallPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withFirewallPolicy(firewallPolicy);
        return this;
    }

    public HubIpAddresses hubIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().hubIpAddresses();
    }

    public AzureFirewallInner withHubIpAddresses(HubIpAddresses hubIpAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withHubIpAddresses(hubIpAddresses);
        return this;
    }

    public List<AzureFirewallIpGroups> ipGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().ipGroups();
    }

    public AzureFirewallSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public AzureFirewallInner withSku(AzureFirewallSku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public Map<String, String> additionalProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalProperties();
    }

    public AzureFirewallInner withAdditionalProperties(Map<String, String> additionalProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withAdditionalProperties(additionalProperties);
        return this;
    }

    public AzureFirewallAutoscaleConfiguration autoscaleConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().autoscaleConfiguration();
    }

    public AzureFirewallInner withAutoscaleConfiguration(AzureFirewallAutoscaleConfiguration autoscaleConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureFirewallPropertiesFormat();
        }
        this.innerProperties().withAutoscaleConfiguration(autoscaleConfiguration);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static AzureFirewallInner fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFirewallInner)((Object)jsonReader.readObject(reader -> {
            AzureFirewallInner deserializedAzureFirewallInner = new AzureFirewallInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureFirewallInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureFirewallInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAzureFirewallInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAzureFirewallInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAzureFirewallInner.innerProperties = AzureFirewallPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedAzureFirewallInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedAzureFirewallInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedAzureFirewallInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFirewallInner;
        }));
    }
}

