/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ManagedRuleOverride;
import java.io.IOException;
import java.util.List;

public final class ManagedRuleGroupOverride
implements JsonSerializable<ManagedRuleGroupOverride> {
    private String ruleGroupName;
    private List<ManagedRuleOverride> rules;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleGroupOverride.class);

    public String ruleGroupName() {
        return this.ruleGroupName;
    }

    public ManagedRuleGroupOverride withRuleGroupName(String ruleGroupName) {
        this.ruleGroupName = ruleGroupName;
        return this;
    }

    public List<ManagedRuleOverride> rules() {
        return this.rules;
    }

    public ManagedRuleGroupOverride withRules(List<ManagedRuleOverride> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.ruleGroupName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleGroupName in model ManagedRuleGroupOverride"));
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleGroupName", this.ruleGroupName);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedRuleGroupOverride fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedRuleGroupOverride)jsonReader.readObject(reader -> {
            ManagedRuleGroupOverride deserializedManagedRuleGroupOverride = new ManagedRuleGroupOverride();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleGroupName".equals(fieldName)) {
                    deserializedManagedRuleGroupOverride.ruleGroupName = reader.getString();
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedManagedRuleGroupOverride.rules = rules = reader.readArray(reader1 -> ManagedRuleOverride.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedRuleGroupOverride;
        });
    }
}

