/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FlowLogFormatType;
import java.io.IOException;

public final class FlowLogFormatParameters
implements JsonSerializable<FlowLogFormatParameters> {
    private FlowLogFormatType type;
    private Integer version;

    public FlowLogFormatType type() {
        return this.type;
    }

    public FlowLogFormatParameters withType(FlowLogFormatType type) {
        this.type = type;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public FlowLogFormatParameters withVersion(Integer version) {
        this.version = version;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("version", (Number)this.version);
        return jsonWriter.writeEndObject();
    }

    public static FlowLogFormatParameters fromJson(JsonReader jsonReader) throws IOException {
        return (FlowLogFormatParameters)jsonReader.readObject(reader -> {
            FlowLogFormatParameters deserializedFlowLogFormatParameters = new FlowLogFormatParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedFlowLogFormatParameters.type = FlowLogFormatType.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedFlowLogFormatParameters.version = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlowLogFormatParameters;
        });
    }
}

