/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.GatewayResiliencyRecommendation;
import java.io.IOException;
import java.util.List;

public final class ResiliencyRecommendationComponents
implements JsonSerializable<ResiliencyRecommendationComponents> {
    private String name;
    private String currentScore;
    private String maxScore;
    private List<GatewayResiliencyRecommendation> recommendations;

    public String name() {
        return this.name;
    }

    public ResiliencyRecommendationComponents withName(String name) {
        this.name = name;
        return this;
    }

    public String currentScore() {
        return this.currentScore;
    }

    public ResiliencyRecommendationComponents withCurrentScore(String currentScore) {
        this.currentScore = currentScore;
        return this;
    }

    public String maxScore() {
        return this.maxScore;
    }

    public ResiliencyRecommendationComponents withMaxScore(String maxScore) {
        this.maxScore = maxScore;
        return this;
    }

    public List<GatewayResiliencyRecommendation> recommendations() {
        return this.recommendations;
    }

    public ResiliencyRecommendationComponents withRecommendations(List<GatewayResiliencyRecommendation> recommendations) {
        this.recommendations = recommendations;
        return this;
    }

    public void validate() {
        if (this.recommendations() != null) {
            this.recommendations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("currentScore", this.currentScore);
        jsonWriter.writeStringField("maxScore", this.maxScore);
        jsonWriter.writeArrayField("recommendations", this.recommendations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResiliencyRecommendationComponents fromJson(JsonReader jsonReader) throws IOException {
        return (ResiliencyRecommendationComponents)jsonReader.readObject(reader -> {
            ResiliencyRecommendationComponents deserializedResiliencyRecommendationComponents = new ResiliencyRecommendationComponents();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResiliencyRecommendationComponents.name = reader.getString();
                    continue;
                }
                if ("currentScore".equals(fieldName)) {
                    deserializedResiliencyRecommendationComponents.currentScore = reader.getString();
                    continue;
                }
                if ("maxScore".equals(fieldName)) {
                    deserializedResiliencyRecommendationComponents.maxScore = reader.getString();
                    continue;
                }
                if ("recommendations".equals(fieldName)) {
                    List recommendations;
                    deserializedResiliencyRecommendationComponents.recommendations = recommendations = reader.readArray(reader1 -> GatewayResiliencyRecommendation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResiliencyRecommendationComponents;
        });
    }
}

