/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddressPool;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class Utils {
    private Utils() {
    }

    static Subnet getAssociatedSubnet(NetworkManager manager, SubResource subnetRef) {
        if (subnetRef == null) {
            return null;
        }
        String vnetId = ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        String subnetName = ResourceUtils.nameFromResourceId((String)subnetRef.id());
        if (vnetId == null || subnetName == null) {
            return null;
        }
        Network network = (Network)manager.networks().getById(vnetId);
        if (network == null) {
            return null;
        }
        return network.subnets().get(subnetName);
    }

    static List<Subnet> listAssociatedSubnets(NetworkManager manager, List<SubnetInner> subnetRefs) {
        HashMap<String, Network> networks = new HashMap<String, Network>();
        ArrayList<Subnet> subnets = new ArrayList<Subnet>();
        if (subnetRefs != null) {
            for (SubnetInner subnetRef : subnetRefs) {
                String networkId = ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
                Network network = (Network)networks.get(networkId.toLowerCase(Locale.ROOT));
                if (network == null) {
                    network = (Network)manager.networks().getById(networkId);
                    networks.put(networkId.toLowerCase(Locale.ROOT), network);
                }
                String subnetName = ResourceUtils.nameFromResourceId((String)subnetRef.id());
                subnets.add(network.subnets().get(subnetName));
            }
        }
        return Collections.unmodifiableList(subnets);
    }

    static Collection<ApplicationGatewayBackend> listAssociatedApplicationGatewayBackends(NetworkManager manager, List<ApplicationGatewayBackendAddressPool> backendRefs) {
        HashMap<String, ApplicationGateway> appGateways = new HashMap<String, ApplicationGateway>();
        ArrayList<ApplicationGatewayBackend> backends = new ArrayList<ApplicationGatewayBackend>();
        if (backendRefs != null) {
            for (ApplicationGatewayBackendAddressPool backendRef : backendRefs) {
                String appGatewayId = ResourceUtils.parentResourceIdFromResourceId((String)backendRef.id());
                ApplicationGateway appGateway = (ApplicationGateway)appGateways.get(appGatewayId.toLowerCase(Locale.ROOT));
                if (appGateway == null) {
                    appGateway = (ApplicationGateway)manager.applicationGateways().getById(appGatewayId);
                    appGateways.put(appGatewayId.toLowerCase(Locale.ROOT), appGateway);
                }
                String backendName = ResourceUtils.nameFromResourceId((String)backendRef.id());
                backends.add(appGateway.backends().get(backendName));
            }
        }
        return Collections.unmodifiableCollection(backends);
    }
}

