/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import java.io.IOException;
import java.util.List;

public final class NetworkInterfaceAssociation
implements JsonSerializable<NetworkInterfaceAssociation> {
    private String id;
    private List<SecurityRuleInner> securityRules;

    public String id() {
        return this.id;
    }

    public List<SecurityRuleInner> securityRules() {
        return this.securityRules;
    }

    public NetworkInterfaceAssociation withSecurityRules(List<SecurityRuleInner> securityRules) {
        this.securityRules = securityRules;
        return this;
    }

    public void validate() {
        if (this.securityRules() != null) {
            this.securityRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("securityRules", this.securityRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterfaceAssociation fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterfaceAssociation)jsonReader.readObject(reader -> {
            NetworkInterfaceAssociation deserializedNetworkInterfaceAssociation = new NetworkInterfaceAssociation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNetworkInterfaceAssociation.id = reader.getString();
                    continue;
                }
                if ("securityRules".equals(fieldName)) {
                    List securityRules;
                    deserializedNetworkInterfaceAssociation.securityRules = securityRules = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterfaceAssociation;
        });
    }
}

