/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.RouteInner;
import com.azure.resourcemanager.network.fluent.models.RouteTableInner;
import com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.azure.resourcemanager.network.implementation.RouteImpl;
import com.azure.resourcemanager.network.implementation.Utils;
import com.azure.resourcemanager.network.models.Route;
import com.azure.resourcemanager.network.models.RouteNextHopType;
import com.azure.resourcemanager.network.models.RouteTable;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Mono;

class RouteTableImpl
extends GroupableParentResourceWithTagsImpl<RouteTable, RouteTableInner, RouteTableImpl, NetworkManager>
implements RouteTable,
RouteTable.Definition,
RouteTable.Update {
    private Map<String, Route> routes;

    RouteTableImpl(String name, RouteTableInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    @Override
    protected Mono<RouteTableInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getRouteTables().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((RouteTableInner)((Object)this.innerModel())).tags()));
    }

    protected void initializeChildrenFromInner() {
        this.routes = new TreeMap<String, Route>();
        List<RouteInner> inners = ((RouteTableInner)((Object)this.innerModel())).routes();
        if (inners != null) {
            for (RouteInner inner : inners) {
                RouteImpl route = new RouteImpl(inner, this);
                this.routes.put(inner.name(), route);
            }
        }
    }

    public Mono<RouteTable> refreshAsync() {
        return super.refreshAsync().map(routeTable -> {
            RouteTableImpl impl = (RouteTableImpl)routeTable;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    protected Mono<RouteTableInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getRouteTables().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public List<Subnet> listAssociatedSubnets() {
        return Utils.listAssociatedSubnets((NetworkManager)this.myManager, ((RouteTableInner)((Object)this.innerModel())).subnets());
    }

    public RouteImpl defineRoute(String name) {
        RouteInner inner = new RouteInner().withName(name);
        return new RouteImpl(inner, this);
    }

    @Override
    public RouteImpl updateRoute(String name) {
        return (RouteImpl)this.routes.get(name);
    }

    @Override
    public RouteTable.Update withoutRoute(String name) {
        this.routes.remove(name);
        return this;
    }

    @Override
    public RouteTableImpl withRoute(String destinationAddressPrefix, RouteNextHopType nextHop) {
        return this.defineRoute("route_" + this.name() + System.currentTimeMillis()).withDestinationAddressPrefix(destinationAddressPrefix).withNextHop(nextHop).attach();
    }

    @Override
    public RouteTableImpl withRouteViaVirtualAppliance(String destinationAddressPrefix, String ipAddress) {
        return this.defineRoute("route_" + this.name() + System.currentTimeMillis()).withDestinationAddressPrefix(destinationAddressPrefix).withNextHopToVirtualAppliance(ipAddress).attach();
    }

    RouteTableImpl withRoute(RouteImpl route) {
        this.routes.put(route.name(), route);
        return this;
    }

    protected void beforeCreating() {
        ((RouteTableInner)((Object)this.innerModel())).withRoutes(this.innersFromWrappers(this.routes.values()));
    }

    protected Mono<RouteTableInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getRouteTables().createOrUpdateAsync(this.resourceGroupName(), this.name(), (RouteTableInner)((Object)this.innerModel()));
    }

    @Override
    public Map<String, Route> routes() {
        return Collections.unmodifiableMap(this.routes);
    }

    @Override
    public boolean isBgpRoutePropagationDisabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((RouteTableInner)((Object)this.innerModel())).disableBgpRoutePropagation());
    }

    @Override
    public RouteTableImpl withDisableBgpRoutePropagation() {
        ((RouteTableInner)((Object)this.innerModel())).withDisableBgpRoutePropagation(true);
        return this;
    }

    @Override
    public RouteTableImpl withEnableBgpRoutePropagation() {
        ((RouteTableInner)((Object)this.innerModel())).withDisableBgpRoutePropagation(false);
        return this;
    }
}

