/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.RoutingRuleNextHopType;
import java.io.IOException;

public final class RoutingRuleNextHop
implements JsonSerializable<RoutingRuleNextHop> {
    private RoutingRuleNextHopType nextHopType;
    private String nextHopAddress;
    private static final ClientLogger LOGGER = new ClientLogger(RoutingRuleNextHop.class);

    public RoutingRuleNextHopType nextHopType() {
        return this.nextHopType;
    }

    public RoutingRuleNextHop withNextHopType(RoutingRuleNextHopType nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    public String nextHopAddress() {
        return this.nextHopAddress;
    }

    public RoutingRuleNextHop withNextHopAddress(String nextHopAddress) {
        this.nextHopAddress = nextHopAddress;
        return this;
    }

    public void validate() {
        if (this.nextHopType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nextHopType in model RoutingRuleNextHop"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextHopType", this.nextHopType == null ? null : this.nextHopType.toString());
        jsonWriter.writeStringField("nextHopAddress", this.nextHopAddress);
        return jsonWriter.writeEndObject();
    }

    public static RoutingRuleNextHop fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingRuleNextHop)jsonReader.readObject(reader -> {
            RoutingRuleNextHop deserializedRoutingRuleNextHop = new RoutingRuleNextHop();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextHopType".equals(fieldName)) {
                    deserializedRoutingRuleNextHop.nextHopType = RoutingRuleNextHopType.fromString(reader.getString());
                    continue;
                }
                if ("nextHopAddress".equals(fieldName)) {
                    deserializedRoutingRuleNextHop.nextHopAddress = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingRuleNextHop;
        });
    }
}

