/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DhGroup;
import com.azure.resourcemanager.network.models.IkeEncryption;
import com.azure.resourcemanager.network.models.IkeIntegrity;
import com.azure.resourcemanager.network.models.IpsecEncryption;
import com.azure.resourcemanager.network.models.IpsecIntegrity;
import com.azure.resourcemanager.network.models.PfsGroup;
import java.io.IOException;

public final class IpsecPolicy
implements JsonSerializable<IpsecPolicy> {
    private int saLifeTimeSeconds;
    private int saDataSizeKilobytes;
    private IpsecEncryption ipsecEncryption;
    private IpsecIntegrity ipsecIntegrity;
    private IkeEncryption ikeEncryption;
    private IkeIntegrity ikeIntegrity;
    private DhGroup dhGroup;
    private PfsGroup pfsGroup;
    private static final ClientLogger LOGGER = new ClientLogger(IpsecPolicy.class);

    public int saLifeTimeSeconds() {
        return this.saLifeTimeSeconds;
    }

    public IpsecPolicy withSaLifeTimeSeconds(int saLifeTimeSeconds) {
        this.saLifeTimeSeconds = saLifeTimeSeconds;
        return this;
    }

    public int saDataSizeKilobytes() {
        return this.saDataSizeKilobytes;
    }

    public IpsecPolicy withSaDataSizeKilobytes(int saDataSizeKilobytes) {
        this.saDataSizeKilobytes = saDataSizeKilobytes;
        return this;
    }

    public IpsecEncryption ipsecEncryption() {
        return this.ipsecEncryption;
    }

    public IpsecPolicy withIpsecEncryption(IpsecEncryption ipsecEncryption) {
        this.ipsecEncryption = ipsecEncryption;
        return this;
    }

    public IpsecIntegrity ipsecIntegrity() {
        return this.ipsecIntegrity;
    }

    public IpsecPolicy withIpsecIntegrity(IpsecIntegrity ipsecIntegrity) {
        this.ipsecIntegrity = ipsecIntegrity;
        return this;
    }

    public IkeEncryption ikeEncryption() {
        return this.ikeEncryption;
    }

    public IpsecPolicy withIkeEncryption(IkeEncryption ikeEncryption) {
        this.ikeEncryption = ikeEncryption;
        return this;
    }

    public IkeIntegrity ikeIntegrity() {
        return this.ikeIntegrity;
    }

    public IpsecPolicy withIkeIntegrity(IkeIntegrity ikeIntegrity) {
        this.ikeIntegrity = ikeIntegrity;
        return this;
    }

    public DhGroup dhGroup() {
        return this.dhGroup;
    }

    public IpsecPolicy withDhGroup(DhGroup dhGroup) {
        this.dhGroup = dhGroup;
        return this;
    }

    public PfsGroup pfsGroup() {
        return this.pfsGroup;
    }

    public IpsecPolicy withPfsGroup(PfsGroup pfsGroup) {
        this.pfsGroup = pfsGroup;
        return this;
    }

    public void validate() {
        if (this.ipsecEncryption() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipsecEncryption in model IpsecPolicy"));
        }
        if (this.ipsecIntegrity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipsecIntegrity in model IpsecPolicy"));
        }
        if (this.ikeEncryption() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ikeEncryption in model IpsecPolicy"));
        }
        if (this.ikeIntegrity() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ikeIntegrity in model IpsecPolicy"));
        }
        if (this.dhGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dhGroup in model IpsecPolicy"));
        }
        if (this.pfsGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property pfsGroup in model IpsecPolicy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("saLifeTimeSeconds", this.saLifeTimeSeconds);
        jsonWriter.writeIntField("saDataSizeKilobytes", this.saDataSizeKilobytes);
        jsonWriter.writeStringField("ipsecEncryption", this.ipsecEncryption == null ? null : this.ipsecEncryption.toString());
        jsonWriter.writeStringField("ipsecIntegrity", this.ipsecIntegrity == null ? null : this.ipsecIntegrity.toString());
        jsonWriter.writeStringField("ikeEncryption", this.ikeEncryption == null ? null : this.ikeEncryption.toString());
        jsonWriter.writeStringField("ikeIntegrity", this.ikeIntegrity == null ? null : this.ikeIntegrity.toString());
        jsonWriter.writeStringField("dhGroup", this.dhGroup == null ? null : this.dhGroup.toString());
        jsonWriter.writeStringField("pfsGroup", this.pfsGroup == null ? null : this.pfsGroup.toString());
        return jsonWriter.writeEndObject();
    }

    public static IpsecPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (IpsecPolicy)jsonReader.readObject(reader -> {
            IpsecPolicy deserializedIpsecPolicy = new IpsecPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("saLifeTimeSeconds".equals(fieldName)) {
                    deserializedIpsecPolicy.saLifeTimeSeconds = reader.getInt();
                    continue;
                }
                if ("saDataSizeKilobytes".equals(fieldName)) {
                    deserializedIpsecPolicy.saDataSizeKilobytes = reader.getInt();
                    continue;
                }
                if ("ipsecEncryption".equals(fieldName)) {
                    deserializedIpsecPolicy.ipsecEncryption = IpsecEncryption.fromString(reader.getString());
                    continue;
                }
                if ("ipsecIntegrity".equals(fieldName)) {
                    deserializedIpsecPolicy.ipsecIntegrity = IpsecIntegrity.fromString(reader.getString());
                    continue;
                }
                if ("ikeEncryption".equals(fieldName)) {
                    deserializedIpsecPolicy.ikeEncryption = IkeEncryption.fromString(reader.getString());
                    continue;
                }
                if ("ikeIntegrity".equals(fieldName)) {
                    deserializedIpsecPolicy.ikeIntegrity = IkeIntegrity.fromString(reader.getString());
                    continue;
                }
                if ("dhGroup".equals(fieldName)) {
                    deserializedIpsecPolicy.dhGroup = DhGroup.fromString(reader.getString());
                    continue;
                }
                if ("pfsGroup".equals(fieldName)) {
                    deserializedIpsecPolicy.pfsGroup = PfsGroup.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpsecPolicy;
        });
    }
}

