/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpTraffic;
import java.io.IOException;

public final class IntentContent
implements JsonSerializable<IntentContent> {
    private String description;
    private String sourceResourceId;
    private String destinationResourceId;
    private IpTraffic ipTraffic;
    private static final ClientLogger LOGGER = new ClientLogger(IntentContent.class);

    public String description() {
        return this.description;
    }

    public IntentContent withDescription(String description) {
        this.description = description;
        return this;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public IntentContent withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    public String destinationResourceId() {
        return this.destinationResourceId;
    }

    public IntentContent withDestinationResourceId(String destinationResourceId) {
        this.destinationResourceId = destinationResourceId;
        return this;
    }

    public IpTraffic ipTraffic() {
        return this.ipTraffic;
    }

    public IntentContent withIpTraffic(IpTraffic ipTraffic) {
        this.ipTraffic = ipTraffic;
        return this;
    }

    public void validate() {
        if (this.sourceResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceResourceId in model IntentContent"));
        }
        if (this.destinationResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinationResourceId in model IntentContent"));
        }
        if (this.ipTraffic() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipTraffic in model IntentContent"));
        }
        this.ipTraffic().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId);
        jsonWriter.writeStringField("destinationResourceId", this.destinationResourceId);
        jsonWriter.writeJsonField("ipTraffic", (JsonSerializable)this.ipTraffic);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static IntentContent fromJson(JsonReader jsonReader) throws IOException {
        return (IntentContent)jsonReader.readObject(reader -> {
            IntentContent deserializedIntentContent = new IntentContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedIntentContent.sourceResourceId = reader.getString();
                    continue;
                }
                if ("destinationResourceId".equals(fieldName)) {
                    deserializedIntentContent.destinationResourceId = reader.getString();
                    continue;
                }
                if ("ipTraffic".equals(fieldName)) {
                    deserializedIntentContent.ipTraffic = IpTraffic.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIntentContent.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIntentContent;
        });
    }
}

