/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ResourceNavigationLinkFormat
implements JsonSerializable<ResourceNavigationLinkFormat> {
    private String linkedResourceType;
    private String link;
    private ProvisioningState provisioningState;

    public String linkedResourceType() {
        return this.linkedResourceType;
    }

    public ResourceNavigationLinkFormat withLinkedResourceType(String linkedResourceType) {
        this.linkedResourceType = linkedResourceType;
        return this;
    }

    public String link() {
        return this.link;
    }

    public ResourceNavigationLinkFormat withLink(String link) {
        this.link = link;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("linkedResourceType", this.linkedResourceType);
        jsonWriter.writeStringField("link", this.link);
        return jsonWriter.writeEndObject();
    }

    public static ResourceNavigationLinkFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceNavigationLinkFormat)jsonReader.readObject(reader -> {
            ResourceNavigationLinkFormat deserializedResourceNavigationLinkFormat = new ResourceNavigationLinkFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedResourceType".equals(fieldName)) {
                    deserializedResourceNavigationLinkFormat.linkedResourceType = reader.getString();
                    continue;
                }
                if ("link".equals(fieldName)) {
                    deserializedResourceNavigationLinkFormat.link = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedResourceNavigationLinkFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceNavigationLinkFormat;
        });
    }
}

