/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectivityGroupItem;
import com.azure.resourcemanager.network.models.ConnectivityTopology;
import com.azure.resourcemanager.network.models.DeleteExistingPeering;
import com.azure.resourcemanager.network.models.Hub;
import com.azure.resourcemanager.network.models.IsGlobal;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ConnectivityConfigurationProperties
implements JsonSerializable<ConnectivityConfigurationProperties> {
    private String description;
    private ConnectivityTopology connectivityTopology;
    private List<Hub> hubs;
    private IsGlobal isGlobal;
    private List<ConnectivityGroupItem> appliesToGroups;
    private ProvisioningState provisioningState;
    private DeleteExistingPeering deleteExistingPeering;
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityConfigurationProperties.class);

    public String description() {
        return this.description;
    }

    public ConnectivityConfigurationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public ConnectivityTopology connectivityTopology() {
        return this.connectivityTopology;
    }

    public ConnectivityConfigurationProperties withConnectivityTopology(ConnectivityTopology connectivityTopology) {
        this.connectivityTopology = connectivityTopology;
        return this;
    }

    public List<Hub> hubs() {
        return this.hubs;
    }

    public ConnectivityConfigurationProperties withHubs(List<Hub> hubs) {
        this.hubs = hubs;
        return this;
    }

    public IsGlobal isGlobal() {
        return this.isGlobal;
    }

    public ConnectivityConfigurationProperties withIsGlobal(IsGlobal isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    public List<ConnectivityGroupItem> appliesToGroups() {
        return this.appliesToGroups;
    }

    public ConnectivityConfigurationProperties withAppliesToGroups(List<ConnectivityGroupItem> appliesToGroups) {
        this.appliesToGroups = appliesToGroups;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeleteExistingPeering deleteExistingPeering() {
        return this.deleteExistingPeering;
    }

    public ConnectivityConfigurationProperties withDeleteExistingPeering(DeleteExistingPeering deleteExistingPeering) {
        this.deleteExistingPeering = deleteExistingPeering;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.connectivityTopology() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectivityTopology in model ConnectivityConfigurationProperties"));
        }
        if (this.hubs() != null) {
            this.hubs().forEach(e -> e.validate());
        }
        if (this.appliesToGroups() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appliesToGroups in model ConnectivityConfigurationProperties"));
        }
        this.appliesToGroups().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectivityTopology", this.connectivityTopology == null ? null : this.connectivityTopology.toString());
        jsonWriter.writeArrayField("appliesToGroups", this.appliesToGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("hubs", this.hubs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("isGlobal", this.isGlobal == null ? null : this.isGlobal.toString());
        jsonWriter.writeStringField("deleteExistingPeering", this.deleteExistingPeering == null ? null : this.deleteExistingPeering.toString());
        return jsonWriter.writeEndObject();
    }

    public static ConnectivityConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivityConfigurationProperties)jsonReader.readObject(reader -> {
            ConnectivityConfigurationProperties deserializedConnectivityConfigurationProperties = new ConnectivityConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectivityTopology".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.connectivityTopology = ConnectivityTopology.fromString(reader.getString());
                    continue;
                }
                if ("appliesToGroups".equals(fieldName)) {
                    List appliesToGroups;
                    deserializedConnectivityConfigurationProperties.appliesToGroups = appliesToGroups = reader.readArray(reader1 -> ConnectivityGroupItem.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.description = reader.getString();
                    continue;
                }
                if ("hubs".equals(fieldName)) {
                    List hubs;
                    deserializedConnectivityConfigurationProperties.hubs = hubs = reader.readArray(reader1 -> Hub.fromJson(reader1));
                    continue;
                }
                if ("isGlobal".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.isGlobal = IsGlobal.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deleteExistingPeering".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.deleteExistingPeering = DeleteExistingPeering.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedConnectivityConfigurationProperties.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivityConfigurationProperties;
        });
    }
}

