/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.HubBgpConnectionStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class BgpConnectionProperties
implements JsonSerializable<BgpConnectionProperties> {
    private Long peerAsn;
    private String peerIp;
    private SubResource hubVirtualNetworkConnection;
    private ProvisioningState provisioningState;
    private HubBgpConnectionStatus connectionState;

    public Long peerAsn() {
        return this.peerAsn;
    }

    public BgpConnectionProperties withPeerAsn(Long peerAsn) {
        this.peerAsn = peerAsn;
        return this;
    }

    public String peerIp() {
        return this.peerIp;
    }

    public BgpConnectionProperties withPeerIp(String peerIp) {
        this.peerIp = peerIp;
        return this;
    }

    public SubResource hubVirtualNetworkConnection() {
        return this.hubVirtualNetworkConnection;
    }

    public BgpConnectionProperties withHubVirtualNetworkConnection(SubResource hubVirtualNetworkConnection) {
        this.hubVirtualNetworkConnection = hubVirtualNetworkConnection;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public HubBgpConnectionStatus connectionState() {
        return this.connectionState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("peerAsn", (Number)this.peerAsn);
        jsonWriter.writeStringField("peerIp", this.peerIp);
        jsonWriter.writeJsonField("hubVirtualNetworkConnection", (JsonSerializable)this.hubVirtualNetworkConnection);
        return jsonWriter.writeEndObject();
    }

    public static BgpConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BgpConnectionProperties)jsonReader.readObject(reader -> {
            BgpConnectionProperties deserializedBgpConnectionProperties = new BgpConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("peerAsn".equals(fieldName)) {
                    deserializedBgpConnectionProperties.peerAsn = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("peerIp".equals(fieldName)) {
                    deserializedBgpConnectionProperties.peerIp = reader.getString();
                    continue;
                }
                if ("hubVirtualNetworkConnection".equals(fieldName)) {
                    deserializedBgpConnectionProperties.hubVirtualNetworkConnection = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBgpConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("connectionState".equals(fieldName)) {
                    deserializedBgpConnectionProperties.connectionState = HubBgpConnectionStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBgpConnectionProperties;
        });
    }
}

