/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AvailableProvidersListCity;
import java.io.IOException;
import java.util.List;

public final class AvailableProvidersListState
implements JsonSerializable<AvailableProvidersListState> {
    private String stateName;
    private List<String> providers;
    private List<AvailableProvidersListCity> cities;

    public String stateName() {
        return this.stateName;
    }

    public AvailableProvidersListState withStateName(String stateName) {
        this.stateName = stateName;
        return this;
    }

    public List<String> providers() {
        return this.providers;
    }

    public AvailableProvidersListState withProviders(List<String> providers) {
        this.providers = providers;
        return this;
    }

    public List<AvailableProvidersListCity> cities() {
        return this.cities;
    }

    public AvailableProvidersListState withCities(List<AvailableProvidersListCity> cities) {
        this.cities = cities;
        return this;
    }

    public void validate() {
        if (this.cities() != null) {
            this.cities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("stateName", this.stateName);
        jsonWriter.writeArrayField("providers", this.providers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("cities", this.cities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AvailableProvidersListState fromJson(JsonReader jsonReader) throws IOException {
        return (AvailableProvidersListState)jsonReader.readObject(reader -> {
            AvailableProvidersListState deserializedAvailableProvidersListState = new AvailableProvidersListState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stateName".equals(fieldName)) {
                    deserializedAvailableProvidersListState.stateName = reader.getString();
                    continue;
                }
                if ("providers".equals(fieldName)) {
                    List providers;
                    deserializedAvailableProvidersListState.providers = providers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("cities".equals(fieldName)) {
                    List cities;
                    deserializedAvailableProvidersListState.cities = cities = reader.readArray(reader1 -> AvailableProvidersListCity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailableProvidersListState;
        });
    }
}

