/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class LocalNetworkGatewayPropertiesFormat
implements JsonSerializable<LocalNetworkGatewayPropertiesFormat> {
    private AddressSpace localNetworkAddressSpace;
    private String gatewayIpAddress;
    private String fqdn;
    private BgpSettings bgpSettings;
    private String resourceGuid;
    private ProvisioningState provisioningState;

    public AddressSpace localNetworkAddressSpace() {
        return this.localNetworkAddressSpace;
    }

    public LocalNetworkGatewayPropertiesFormat withLocalNetworkAddressSpace(AddressSpace localNetworkAddressSpace) {
        this.localNetworkAddressSpace = localNetworkAddressSpace;
        return this;
    }

    public String gatewayIpAddress() {
        return this.gatewayIpAddress;
    }

    public LocalNetworkGatewayPropertiesFormat withGatewayIpAddress(String gatewayIpAddress) {
        this.gatewayIpAddress = gatewayIpAddress;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public LocalNetworkGatewayPropertiesFormat withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    public LocalNetworkGatewayPropertiesFormat withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.localNetworkAddressSpace() != null) {
            this.localNetworkAddressSpace().validate();
        }
        if (this.bgpSettings() != null) {
            this.bgpSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("localNetworkAddressSpace", (JsonSerializable)this.localNetworkAddressSpace);
        jsonWriter.writeStringField("gatewayIpAddress", this.gatewayIpAddress);
        jsonWriter.writeStringField("fqdn", this.fqdn);
        jsonWriter.writeJsonField("bgpSettings", (JsonSerializable)this.bgpSettings);
        return jsonWriter.writeEndObject();
    }

    public static LocalNetworkGatewayPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (LocalNetworkGatewayPropertiesFormat)jsonReader.readObject(reader -> {
            LocalNetworkGatewayPropertiesFormat deserializedLocalNetworkGatewayPropertiesFormat = new LocalNetworkGatewayPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("localNetworkAddressSpace".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.localNetworkAddressSpace = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("gatewayIpAddress".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.gatewayIpAddress = reader.getString();
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.fqdn = reader.getString();
                    continue;
                }
                if ("bgpSettings".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.bgpSettings = BgpSettings.fromJson(reader);
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedLocalNetworkGatewayPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocalNetworkGatewayPropertiesFormat;
        });
    }
}

