/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.azure.resourcemanager.network.models.ManagedRulesDefinition;
import com.azure.resourcemanager.network.models.PolicySettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.WebApplicationFirewallCustomRule;
import com.azure.resourcemanager.network.models.WebApplicationFirewallPolicyResourceState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class WebApplicationFirewallPolicyPropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebApplicationFirewallPolicyPropertiesFormat.class);
    @JsonProperty(value="policySettings")
    private PolicySettings policySettings;
    @JsonProperty(value="customRules")
    private List<WebApplicationFirewallCustomRule> customRules;
    @JsonProperty(value="applicationGateways", access=JsonProperty.Access.WRITE_ONLY)
    private List<ApplicationGatewayInner> applicationGateways;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private WebApplicationFirewallPolicyResourceState resourceState;
    @JsonProperty(value="managedRules", required=true)
    private ManagedRulesDefinition managedRules;
    @JsonProperty(value="httpListeners", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> httpListeners;
    @JsonProperty(value="pathBasedRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> pathBasedRules;

    public PolicySettings policySettings() {
        return this.policySettings;
    }

    public WebApplicationFirewallPolicyPropertiesFormat withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    public List<WebApplicationFirewallCustomRule> customRules() {
        return this.customRules;
    }

    public WebApplicationFirewallPolicyPropertiesFormat withCustomRules(List<WebApplicationFirewallCustomRule> customRules) {
        this.customRules = customRules;
        return this;
    }

    public List<ApplicationGatewayInner> applicationGateways() {
        return this.applicationGateways;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public WebApplicationFirewallPolicyResourceState resourceState() {
        return this.resourceState;
    }

    public ManagedRulesDefinition managedRules() {
        return this.managedRules;
    }

    public WebApplicationFirewallPolicyPropertiesFormat withManagedRules(ManagedRulesDefinition managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    public List<SubResource> httpListeners() {
        return this.httpListeners;
    }

    public List<SubResource> pathBasedRules() {
        return this.pathBasedRules;
    }

    public void validate() {
        if (this.policySettings() != null) {
            this.policySettings().validate();
        }
        if (this.customRules() != null) {
            this.customRules().forEach(e -> e.validate());
        }
        if (this.applicationGateways() != null) {
            this.applicationGateways().forEach(e -> e.validate());
        }
        if (this.managedRules() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property managedRules in model WebApplicationFirewallPolicyPropertiesFormat"));
        }
        this.managedRules().validate();
    }
}

