/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnLinkBgpSettings;
import com.azure.resourcemanager.network.models.VpnLinkProviderProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class VpnSiteLinkProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VpnSiteLinkProperties.class);
    @JsonProperty(value="linkProperties")
    private VpnLinkProviderProperties linkProperties;
    @JsonProperty(value="ipAddress")
    private String ipAddress;
    @JsonProperty(value="fqdn")
    private String fqdn;
    @JsonProperty(value="bgpProperties")
    private VpnLinkBgpSettings bgpProperties;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public VpnLinkProviderProperties linkProperties() {
        return this.linkProperties;
    }

    public VpnSiteLinkProperties withLinkProperties(VpnLinkProviderProperties linkProperties) {
        this.linkProperties = linkProperties;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public VpnSiteLinkProperties withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public VpnSiteLinkProperties withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public VpnLinkBgpSettings bgpProperties() {
        return this.bgpProperties;
    }

    public VpnSiteLinkProperties withBgpProperties(VpnLinkBgpSettings bgpProperties) {
        this.bgpProperties = bgpProperties;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.linkProperties() != null) {
            this.linkProperties().validate();
        }
        if (this.bgpProperties() != null) {
            this.bgpProperties().validate();
        }
    }
}

