/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VpnSiteLinkConnectionInner;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.azure.resourcemanager.network.models.TrafficSelectorPolicy;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.azure.resourcemanager.network.models.VpnConnectionStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VpnConnectionProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VpnConnectionProperties.class);
    @JsonProperty(value="remoteVpnSite")
    private SubResource remoteVpnSite;
    @JsonProperty(value="routingWeight")
    private Integer routingWeight;
    @JsonProperty(value="dpdTimeoutSeconds")
    private Integer dpdTimeoutSeconds;
    @JsonProperty(value="connectionStatus", access=JsonProperty.Access.WRITE_ONLY)
    private VpnConnectionStatus connectionStatus;
    @JsonProperty(value="vpnConnectionProtocolType")
    private VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType;
    @JsonProperty(value="ingressBytesTransferred", access=JsonProperty.Access.WRITE_ONLY)
    private Long ingressBytesTransferred;
    @JsonProperty(value="egressBytesTransferred", access=JsonProperty.Access.WRITE_ONLY)
    private Long egressBytesTransferred;
    @JsonProperty(value="connectionBandwidth")
    private Integer connectionBandwidth;
    @JsonProperty(value="sharedKey")
    private String sharedKey;
    @JsonProperty(value="enableBgp")
    private Boolean enableBgp;
    @JsonProperty(value="usePolicyBasedTrafficSelectors")
    private Boolean usePolicyBasedTrafficSelectors;
    @JsonProperty(value="ipsecPolicies")
    private List<IpsecPolicy> ipsecPolicies;
    @JsonProperty(value="trafficSelectorPolicies")
    private List<TrafficSelectorPolicy> trafficSelectorPolicies;
    @JsonProperty(value="enableRateLimiting")
    private Boolean enableRateLimiting;
    @JsonProperty(value="enableInternetSecurity")
    private Boolean enableInternetSecurity;
    @JsonProperty(value="useLocalAzureIpAddress")
    private Boolean useLocalAzureIpAddress;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="vpnLinkConnections")
    private List<VpnSiteLinkConnectionInner> vpnLinkConnections;
    @JsonProperty(value="routingConfiguration")
    private RoutingConfiguration routingConfiguration;

    public SubResource remoteVpnSite() {
        return this.remoteVpnSite;
    }

    public VpnConnectionProperties withRemoteVpnSite(SubResource remoteVpnSite) {
        this.remoteVpnSite = remoteVpnSite;
        return this;
    }

    public Integer routingWeight() {
        return this.routingWeight;
    }

    public VpnConnectionProperties withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    public Integer dpdTimeoutSeconds() {
        return this.dpdTimeoutSeconds;
    }

    public VpnConnectionProperties withDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
        this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        return this;
    }

    public VpnConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType() {
        return this.vpnConnectionProtocolType;
    }

    public VpnConnectionProperties withVpnConnectionProtocolType(VirtualNetworkGatewayConnectionProtocol vpnConnectionProtocolType) {
        this.vpnConnectionProtocolType = vpnConnectionProtocolType;
        return this;
    }

    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    public Integer connectionBandwidth() {
        return this.connectionBandwidth;
    }

    public VpnConnectionProperties withConnectionBandwidth(Integer connectionBandwidth) {
        this.connectionBandwidth = connectionBandwidth;
        return this;
    }

    public String sharedKey() {
        return this.sharedKey;
    }

    public VpnConnectionProperties withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    public Boolean enableBgp() {
        return this.enableBgp;
    }

    public VpnConnectionProperties withEnableBgp(Boolean enableBgp) {
        this.enableBgp = enableBgp;
        return this;
    }

    public Boolean usePolicyBasedTrafficSelectors() {
        return this.usePolicyBasedTrafficSelectors;
    }

    public VpnConnectionProperties withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        this.usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors;
        return this;
    }

    public List<IpsecPolicy> ipsecPolicies() {
        return this.ipsecPolicies;
    }

    public VpnConnectionProperties withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        this.ipsecPolicies = ipsecPolicies;
        return this;
    }

    public List<TrafficSelectorPolicy> trafficSelectorPolicies() {
        return this.trafficSelectorPolicies;
    }

    public VpnConnectionProperties withTrafficSelectorPolicies(List<TrafficSelectorPolicy> trafficSelectorPolicies) {
        this.trafficSelectorPolicies = trafficSelectorPolicies;
        return this;
    }

    public Boolean enableRateLimiting() {
        return this.enableRateLimiting;
    }

    public VpnConnectionProperties withEnableRateLimiting(Boolean enableRateLimiting) {
        this.enableRateLimiting = enableRateLimiting;
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.enableInternetSecurity;
    }

    public VpnConnectionProperties withEnableInternetSecurity(Boolean enableInternetSecurity) {
        this.enableInternetSecurity = enableInternetSecurity;
        return this;
    }

    public Boolean useLocalAzureIpAddress() {
        return this.useLocalAzureIpAddress;
    }

    public VpnConnectionProperties withUseLocalAzureIpAddress(Boolean useLocalAzureIpAddress) {
        this.useLocalAzureIpAddress = useLocalAzureIpAddress;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<VpnSiteLinkConnectionInner> vpnLinkConnections() {
        return this.vpnLinkConnections;
    }

    public VpnConnectionProperties withVpnLinkConnections(List<VpnSiteLinkConnectionInner> vpnLinkConnections) {
        this.vpnLinkConnections = vpnLinkConnections;
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.routingConfiguration;
    }

    public VpnConnectionProperties withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        this.routingConfiguration = routingConfiguration;
        return this;
    }

    public void validate() {
        if (this.ipsecPolicies() != null) {
            this.ipsecPolicies().forEach(e -> e.validate());
        }
        if (this.trafficSelectorPolicies() != null) {
            this.trafficSelectorPolicies().forEach(e -> e.validate());
        }
        if (this.vpnLinkConnections() != null) {
            this.vpnLinkConnections().forEach(e -> e.validate());
        }
        if (this.routingConfiguration() != null) {
            this.routingConfiguration().validate();
        }
    }
}

