/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.HubRouteTableProperties;
import com.azure.resourcemanager.network.models.HubRoute;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class HubRouteTableInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(HubRouteTableInner.class);
    @JsonProperty(value="properties")
    private HubRouteTableProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private HubRouteTableProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public HubRouteTableInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public HubRouteTableInner withId(String id) {
        super.withId(id);
        return this;
    }

    public List<HubRoute> routes() {
        return this.innerProperties() == null ? null : this.innerProperties().routes();
    }

    public HubRouteTableInner withRoutes(List<HubRoute> routes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HubRouteTableProperties();
        }
        this.innerProperties().withRoutes(routes);
        return this;
    }

    public List<String> labels() {
        return this.innerProperties() == null ? null : this.innerProperties().labels();
    }

    public HubRouteTableInner withLabels(List<String> labels) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HubRouteTableProperties();
        }
        this.innerProperties().withLabels(labels);
        return this;
    }

    public List<String> associatedConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedConnections();
    }

    public List<String> propagatingConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().propagatingConnections();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

