/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RemotePath
implements JsonSerializable<RemotePath> {
    private String externalHostname;
    private String serverName;
    private String volumeName;
    private static final ClientLogger LOGGER = new ClientLogger(RemotePath.class);

    public String externalHostname() {
        return this.externalHostname;
    }

    public RemotePath withExternalHostname(String externalHostname) {
        this.externalHostname = externalHostname;
        return this;
    }

    public String serverName() {
        return this.serverName;
    }

    public RemotePath withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String volumeName() {
        return this.volumeName;
    }

    public RemotePath withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    public void validate() {
        if (this.externalHostname() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property externalHostname in model RemotePath"));
        }
        if (this.serverName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serverName in model RemotePath"));
        }
        if (this.volumeName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property volumeName in model RemotePath"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("externalHostName", this.externalHostname);
        jsonWriter.writeStringField("serverName", this.serverName);
        jsonWriter.writeStringField("volumeName", this.volumeName);
        return jsonWriter.writeEndObject();
    }

    public static RemotePath fromJson(JsonReader jsonReader) throws IOException {
        return (RemotePath)jsonReader.readObject(reader -> {
            RemotePath deserializedRemotePath = new RemotePath();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("externalHostName".equals(fieldName)) {
                    deserializedRemotePath.externalHostname = reader.getString();
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedRemotePath.serverName = reader.getString();
                    continue;
                }
                if ("volumeName".equals(fieldName)) {
                    deserializedRemotePath.volumeName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRemotePath;
        });
    }
}

