/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ReplicationType;
import java.io.IOException;

public final class DestinationReplication
implements JsonSerializable<DestinationReplication> {
    private String resourceId;
    private ReplicationType replicationType;
    private String region;
    private String zone;

    public String resourceId() {
        return this.resourceId;
    }

    public DestinationReplication withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    public DestinationReplication withReplicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    public String region() {
        return this.region;
    }

    public DestinationReplication withRegion(String region) {
        this.region = region;
        return this;
    }

    public String zone() {
        return this.zone;
    }

    public DestinationReplication withZone(String zone) {
        this.zone = zone;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("replicationType", this.replicationType == null ? null : this.replicationType.toString());
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("zone", this.zone);
        return jsonWriter.writeEndObject();
    }

    public static DestinationReplication fromJson(JsonReader jsonReader) throws IOException {
        return (DestinationReplication)jsonReader.readObject(reader -> {
            DestinationReplication deserializedDestinationReplication = new DestinationReplication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedDestinationReplication.resourceId = reader.getString();
                    continue;
                }
                if ("replicationType".equals(fieldName)) {
                    deserializedDestinationReplication.replicationType = ReplicationType.fromString(reader.getString());
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedDestinationReplication.region = reader.getString();
                    continue;
                }
                if ("zone".equals(fieldName)) {
                    deserializedDestinationReplication.zone = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDestinationReplication;
        });
    }
}

