/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.VolumeQuotaRulesClient;
import com.azure.resourcemanager.netapp.fluent.models.VolumeQuotaRuleInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.implementation.VolumeQuotaRuleImpl;
import com.azure.resourcemanager.netapp.models.VolumeQuotaRule;
import com.azure.resourcemanager.netapp.models.VolumeQuotaRules;

public final class VolumeQuotaRulesImpl
implements VolumeQuotaRules {
    private static final ClientLogger LOGGER = new ClientLogger(VolumeQuotaRulesImpl.class);
    private final VolumeQuotaRulesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public VolumeQuotaRulesImpl(VolumeQuotaRulesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<VolumeQuotaRule> listByVolume(String resourceGroupName, String accountName, String poolName, String volumeName) {
        PagedIterable<VolumeQuotaRuleInner> inner = this.serviceClient().listByVolume(resourceGroupName, accountName, poolName, volumeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeQuotaRuleImpl((VolumeQuotaRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VolumeQuotaRule> listByVolume(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        PagedIterable<VolumeQuotaRuleInner> inner = this.serviceClient().listByVolume(resourceGroupName, accountName, poolName, volumeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeQuotaRuleImpl((VolumeQuotaRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<VolumeQuotaRule> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, Context context) {
        Response<VolumeQuotaRuleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VolumeQuotaRuleImpl((VolumeQuotaRuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VolumeQuotaRule get(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        VolumeQuotaRuleInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName);
        if (inner != null) {
            return new VolumeQuotaRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String volumeQuotaRuleName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, context);
    }

    @Override
    public VolumeQuotaRule getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String volumeQuotaRuleName = ResourceManagerUtils.getValueFromIdByName(id, "volumeQuotaRules");
        if (volumeQuotaRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumeQuotaRules'.", id)));
        }
        return (VolumeQuotaRule)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, Context.NONE).getValue();
    }

    @Override
    public Response<VolumeQuotaRule> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String volumeQuotaRuleName = ResourceManagerUtils.getValueFromIdByName(id, "volumeQuotaRules");
        if (volumeQuotaRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumeQuotaRules'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String volumeQuotaRuleName = ResourceManagerUtils.getValueFromIdByName(id, "volumeQuotaRules");
        if (volumeQuotaRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumeQuotaRules'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String volumeQuotaRuleName = ResourceManagerUtils.getValueFromIdByName(id, "volumeQuotaRules");
        if (volumeQuotaRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumeQuotaRules'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, volumeQuotaRuleName, context);
    }

    private VolumeQuotaRulesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeQuotaRuleImpl define(String name) {
        return new VolumeQuotaRuleImpl(name, this.manager());
    }
}

